CREATE TABLE aws_credentials
(
    id          integer      NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    name        varchar(255) NOT NULL,
    access_key  varchar(255) NOT NULL,
    private_key varchar(255) NOT NULL,
    CONSTRAINT aws_credentials_pk PRIMARY KEY (id)
);

CREATE TABLE bucket
(
    id                 integer      NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    name               varchar(255) NOT NULL,
    description        varchar(255) NULL,
    region             varchar(255) NOT NULL,
    volume_setting_id  int8         NOT NULL,
    aws_credentials_id integer      NOT NULL,
    CONSTRAINT bucket_aws_credentials_fk FOREIGN KEY (aws_credentials_id) REFERENCES aws_credentials (id),
    CONSTRAINT bucket_aws_volume_setting_id_fk FOREIGN KEY (volume_setting_id) REFERENCES volume (id)
);