CREATE TABLE storage_price
(
    id              integer      NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    description     varchar(255) NULL,
    currency_symbol varchar(255) NULL,
    price           decimal      NOT NULL,
    CONSTRAINT storage_price_pkey PRIMARY KEY (id)
);

ALTER TABLE volume
    ADD COLUMN storage_price_id integer NULL;
ALTER TABLE volume
    ADD CONSTRAINT storage_price_id_fkey FOREIGN KEY (storage_price_id) REFERENCES storage_price (id);

INSERT INTO storage_price (description, currency_symbol, price)
VALUES ('HDD', '$', 0.35);

INSERT INTO storage_price (description, currency_symbol, price)
VALUES ('SSD', '$', 0.65);

INSERT INTO storage_price (description, currency_symbol, price)
VALUES ('NVMe', '$', 1.75);

UPDATE volume SET storage_price_id = 1;