CREATE TABLE "archiware_p5_credential"
(
    id        int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    "name" varchar(255) NOT NULL,
    "url"  varchar(255)  NOT NULL,
    "username"      varchar(255) NOT NULL,
    "password" varchar(100) NOT NULL,
    CONSTRAINT archiware_p5_credential_pkey PRIMARY KEY (id)
);

CREATE TABLE "archiware_p5_index"
(
    id        int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    "index_id" varchar(255) NOT NULL,
    "path"  varchar(255)  NOT NULL,
    "volume_setting_id"  int8 NOT NULL,
    "archiware_p5_credential_id" int8,
    CONSTRAINT archiware_p5_index_pkey PRIMARY KEY (id),
    CONSTRAINT fk_volume_setting_id
    FOREIGN KEY(volume_setting_id)
    REFERENCES volume(id),
    CONSTRAINT fk_archiware_p5_credential_id
        FOREIGN KEY(archiware_p5_credential_id)
            REFERENCES archiware_p5_credential(id)
);

DROP TABLE archiware;

