CREATE TABLE "server"
(
    id          int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    is_crawling bool         NOT NULL,
    is_master   bool         NOT NULL,
    "name"      varchar(255) NOT NULL,
    CONSTRAINT server_pkey PRIMARY KEY (id),
    CONSTRAINT uk_qsgmrlgxfgo1v98jewa76i5j5 UNIQUE (name)
);

CREATE TABLE volume
(
    id        int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    last_scan timestamp    NULL,
    "name"    varchar(255) NOT NULL,
    "path"    varchar(255) NOT NULL,
    "type"    varchar(255) NOT NULL,
    server_id int8         NULL,
    CONSTRAINT uk_2yf7yu1swed5yphd8pf0syyw1 UNIQUE (name),
    CONSTRAINT volume_pkey PRIMARY KEY (id),
    CONSTRAINT fk9nkqouc07kpu45ee8pq2ferfw FOREIGN KEY (server_id) REFERENCES server (id)
);

CREATE TABLE project
(
    id                int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    allocated_size    int8         NOT NULL,
    creation_date     timestamp    NULL,
    description       varchar(255) NULL,
    modification_date timestamp    NULL,
    "name"            varchar(255) NOT NULL,
    CONSTRAINT project_pkey PRIMARY KEY (id)
);

CREATE TABLE project_path
(
    id         int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    "path"     varchar(255) NOT NULL,
    project_id int8         NULL,
    volume_id  int8         NOT NULL,
    CONSTRAINT project_path_pkey PRIMARY KEY (id),
    CONSTRAINT fk245o2q46wak9ew6w7nvi1o6oe FOREIGN KEY (project_id) REFERENCES project (id),
    CONSTRAINT fkbc3t744s61f0ftg7alfu8o50r FOREIGN KEY (volume_id) REFERENCES volume (id)
);

CREATE TABLE "configuration"
(
    id          int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    description varchar(255) NOT NULL,
    "name"      varchar(255) NOT NULL,
    value       varchar(255) NOT NULL,
    CONSTRAINT configuration_pkey PRIMARY KEY (id)
);

CREATE TABLE app_user
(
    id         int8         NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    created_at timestamp    NOT NULL,
    updated_at timestamp    NOT NULL,
    email      varchar(40)  NULL,
    "name"     varchar(40)  NULL,
    "password" varchar(100) NULL,
    username   varchar(15)  NULL,
    CONSTRAINT app_user_pkey PRIMARY KEY (id),
    CONSTRAINT uk1j9d9a06i600gd43uu3km82jw UNIQUE (email),
    CONSTRAINT uk3k4cplvh82srueuttfkwnylq0 UNIQUE (username)
);

CREATE TABLE "role"
(
    id     int8        NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    "name" varchar(60) NULL,
    CONSTRAINT role_pkey PRIMARY KEY (id),
    CONSTRAINT uk_epk9im9l9q67xmwi4hbed25do UNIQUE (name)
);

CREATE TABLE user_role
(
    user_id int8 NOT NULL,
    role_id int8 NOT NULL,
    CONSTRAINT user_role_pkey PRIMARY KEY (user_id, role_id),
    CONSTRAINT fka68196081fvovjhkek5m97n3y FOREIGN KEY (role_id) REFERENCES role (id),
    CONSTRAINT fkg7fr1r7o0fkk41nfhnjdyqn7b FOREIGN KEY (user_id) REFERENCES app_user (id)
);

CREATE TABLE alert_configuration
(
    id        int8        NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    frequency varchar(5)  NULL,
    threshold float8      NOT NULL,
    "type"    varchar(11) NULL,
    user_id   int8        NULL,
    CONSTRAINT alert_configuration_pkey PRIMARY KEY (id),
    CONSTRAINT fkhpkh4p7jxnif5151p4qlxdr7j FOREIGN KEY (user_id) REFERENCES app_user (id)
);

-- after table creation
INSERT INTO configuration (description, name, value)
VALUES ('The cron configuration for crawl', 'crawl.scheduled', '0 0 0 * * ?');

INSERT INTO configuration (description, name, value)
VALUES ('Number of days to keep snapshot', 'snapshot.numberOfDays', '30');

INSERT INTO configuration (description, name, value)
VALUES ('Keep first day of each month', 'snapshot.keepFirstDayOfMonth', 'true');

INSERT INTO role (name)
VALUES ('ROLE_USER'),
       ('ROLE_ADMIN');

INSERT INTO app_user (created_at, updated_at, email, name, password, username)
VALUES ('2018-09-11 14:54:54', '2018-09-11 14:54:54', 'support@ordigraphe.com', 'Administrator',
        '$2a$10$HGv9bae5RfMcN07jTmyN/utxJLgIQDYz20eAoyi74LPx.pV7bFDiO', 'admin');

INSERT INTO user_role (user_id, role_id)
VALUES (1, 2);

INSERT INTO server (is_crawling, is_master, name)
VALUES (FALSE, TRUE, 'DataIntell');

UPDATE server
SET is_crawling = FALSE;