--  Function to communicate with scanners
CREATE OR REPLACE FUNCTION new_job_notify() RETURNS trigger AS
$$
BEGIN
    PERFORM pg_notify('new_job_channel', NEW.id::text);
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

--  Function to communicate with api
CREATE OR REPLACE FUNCTION job_completed_notify() RETURNS trigger AS
$$
BEGIN
    PERFORM pg_notify('job_success_channel', NEW.id::text);
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

--  Triggers
DROP TRIGGER IF EXISTS new_job ON job;
CREATE TRIGGER new_job
    BEFORE UPDATE OF status
    ON job
    FOR EACH ROW
    WHEN (NEW.status = 'AVAILABLE')
EXECUTE PROCEDURE new_job_notify();

DROP TRIGGER IF EXISTS job_completed ON job;
CREATE TRIGGER job_completed
    BEFORE UPDATE OF status
    ON job
    FOR EACH ROW
    WHEN (NEW.status = 'SCANNER_COMPLETED')
EXECUTE PROCEDURE job_completed_notify();

DROP TRIGGER IF EXISTS job_errored ON job;
CREATE TRIGGER job_errored
    BEFORE UPDATE OF status
    ON job
    FOR EACH ROW
    WHEN (NEW.status = 'SCANNER_ERROR')
EXECUTE PROCEDURE job_completed_notify();