echo "Updating Elasticsearch to latest version..."
echo "Stopping Elasticsearch"
systemctl stop elasticsearch

PATH_DATA=""
XPACK_SECURITY_ENABLED=""
DJAVA_IO_TMPDIR=""

while read line ; do
  if [[ "$line" =~ \path.data ]]
    then PATH_DATA=$line
  elif [[ "$line" =~ \xpack.security.enabled ]]
    then XPACK_SECURITY_ENABLED=$line
  fi
done < /etc/elasticsearch/elasticsearch.yml

while read line ; do
  if [[ "$line" =~ \-Djava.io.tmpdir ]]
    then DJAVA_IO_TMPDIR=$line
  fi
done < /etc/elasticsearch/jvm.options

sudo dpkg -i --force-confnew elasticsearch/elasticsearch.deb

if ! grep -Fxq "xpack.ml.enabled: false" /etc/elasticsearch/elasticsearch.yml
  then sh -c "echo xpack.ml.enabled: false >> /etc/elasticsearch/elasticsearch.yml"
fi

# If we already had configured security, but we update yml file...
if ! grep -Fxq "xpack.security.enabled: true" /etc/elasticsearch/elasticsearch.yml && [[ $XPACK_SECURITY_ENABLED != "" ]]
  then sh -c "echo xpack.security.enabled: true >> /etc/elasticsearch/elasticsearch.yml"
fi

# Delete path.data and add new path.data
sed -i '/path.data/d' /etc/elasticsearch/elasticsearch.yml
sh -c "echo $PATH_DATA >> /etc/elasticsearch/elasticsearch.yml"

# Delete -Djava.io.tmpdir and add new -Djava.io.tmpdir
sed -i '/-Djava.io.tmpdir/d' /etc/elasticsearch/jvm.options
sh -c "echo $DJAVA_IO_TMPDIR >> /etc/elasticsearch/jvm.options"

systemctl daemon-reload
systemctl start elasticsearch
