# Set default values for arguments and port
DOCKER_ARG_APIURL="http://127.0.0.1"
DOCKER_ARG_APIPORT=8085
DOCKER_ARG_THEME_ID="DATAINTELL"
DOCKER_PORT=80

APIURL=$(docker exec dataintell-client printenv REACT_APP_APIURL)
APIPORT=$(docker exec dataintell-client printenv REACT_APP_APIPORT)
THEME_ID=$(docker exec dataintell-client printenv REACT_THEME_ID)
PORT=$(docker port dataintell-client 5000)

display_help() {
  echo "Usage: ./update-dataintell-client-config.sh [options]"
  echo "Options:"
  echo "  -u  Change the API URL"
  echo "  -a  Change the API port"
  echo "  -t  Change the theme ID"
  echo "  -p  Change the client port"
  exit 1
}

while getopts 'u:a:t:p:h' flag; do
  case "${flag}" in
    u) APIURL="${OPTARG}";;
    a) APIPORT="${OPTARG}";;
    t) THEME_ID="${OPTARG}";;
    p) PORT="${OPTARG}";;
    h) display_help
       exit 0
       ;;
  esac
done

echo "Updating DataIntell-client arguments..."

[[ ! -z "$APIURL" ]] && DOCKER_ARG_APIURL="$APIURL"
[[ ! -z "$APIPORT" ]] && DOCKER_ARG_APIPORT="$APIPORT"
[[ ! -z "$THEME_ID" ]] && DOCKER_ARG_THEME_ID="$THEME_ID"
[[ ! -z "$PORT" ]] && DOCKER_PORT="$PORT"

echo "APIURL:" $DOCKER_ARG_APIURL
echo "APIPORT:" $DOCKER_ARG_APIPORT
echo "THEME_ID:" $DOCKER_ARG_THEME_ID
echo "PORT:" $DOCKER_PORT

docker stop dataintell-client
docker rm dataintell-client
docker run -d --restart unless-stopped -p $DOCKER_PORT:5000 -e REACT_APP_APIURL="$DOCKER_ARG_APIURL" \
-e REACT_APP_APIPORT="$DOCKER_ARG_APIPORT" -e REACT_THEME_ID="$DOCKER_ARG_THEME_ID" --name dataintell-client dataintell-client
echo "Finished updating DataIntell-client arguments!"