echo "Updating DataIntell-api to latest version..."
systemctl stop dataintell-api

# updating elasticsearch security if not already configured
if ! grep -Fxq "xpack.security.enabled: true" /etc/elasticsearch/elasticsearch.yml
then
  systemctl stop elasticsearch.service
  echo xpack.security.enabled: true >> /etc/elasticsearch/elasticsearch.yml
  echo es_secret_passwd | /usr/share/elasticsearch/bin/elasticsearch-keystore add bootstrap.password
  systemctl start elasticsearch.service
  curl -uelastic:es_secret_passwd -XPUT -H 'Content-Type: application/json' 'http://localhost:9200/_xpack/security/user/kibana/_password' -d '{ "password":"es_secret_passwd" }'
  curl -uelastic:es_secret_passwd -XPUT -H 'Content-Type: application/json' 'http://localhost:9200/_xpack/security/user/kibana_system/_password' -d '{ "password":"es_secret_passwd" }'
  curl -uelastic:es_secret_passwd -XPUT -H 'Content-Type: application/json' 'http://localhost:9200/_xpack/security/user/logstash_system/_password' -d '{ "password":"es_secret_passwd" }'
  curl -uelastic:es_secret_passwd -XPUT -H 'Content-Type: application/json' 'http://localhost:9200/_xpack/security/user/elastic/_password' -d '{ "password":"es_secret_passwd" }'
fi

# backup existing
mv /usr/local/dataintell/dataintell-api.jar /usr/local/dataintell/dataintell-api.jar.backup

# copy new versions
cp dataintell-api.jar /usr/local/dataintell

# remove jobStore class line in application.properties if present
sed -i '/spring.quartz.properties.org.quartz.jobStore.class/d' /usr/local/dataintell/application.properties

# remove unused quartz init line in db
su postgres -c "psql -v ON_ERROR_STOP=1 --dbname dataintell <<-EOSQL
    DELETE from dataintell.flyway_schema_history where version is null and description = 'quartz init';
EOSQL"

systemctl start dataintell-api
echo "Finished updating DataIntell-api to latest version!"
echo "If you had custom application.properties, make sure to replicate them since they were overrided by the new version"
echo "Don't worry! We made a backup of your stuff under /usr/local/dataintell"