/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.utils;

import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.file.FileService;
import io.dataintell.visionapi.repository.elasticsearch.FileRepository;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TransferTagsManager {
    private static final Logger log = LoggerFactory.getLogger(TransferTagsManager.class);
    private final FileService service;
    private final FileRepository repository;
    @Value(value="${app.scrollSize}")
    private Integer scrollSize;
    @Value(value="${app.scrollTimeToLive}")
    private Integer scrollTimeToLive;

    public TransferTagsManager(FileService service, FileRepository repository) {
        this.service = service;
        this.repository = repository;
    }

    public void transferTagsToNextScanDate(LocalDate previousScanDate, LocalDate currentScanDate) {
        List tags = this.service.getTags(Integer.valueOf(1000), previousScanDate);
        log.info("Starting to transfer tags from last scan to current scan");
        long startTime = System.currentTimeMillis();
        tags.forEach(tag -> {
            log.info("Transfering tag [{}]", tag);
            this.transferTagsWithScroll(previousScanDate, currentScanDate, tag, false);
            this.transferTagsWithScroll(previousScanDate, currentScanDate, tag, true);
        });
        long endTime = System.currentTimeMillis() - startTime;
        log.info("Finished transfering tags took {} ms", (Object)endTime);
    }

    private void transferTagsWithScroll(LocalDate previousScanDate, LocalDate currentScanDate, String tag, boolean isDirectory) {
        PaginatedResult filesWithScroll = this.service.searchFilesWithScroll("", null, null, null, null, null, null, null, null, null, null, null, null, this.scrollSize, this.scrollTimeToLive, "size", null, null, null, null, null, Collections.singletonList(tag), Boolean.valueOf(isDirectory), null, null, null, null, previousScanDate);
        do {
            List fileIds = filesWithScroll.getElements().stream().map(File::getFileId).collect(Collectors.toList());
            this.repository.addTagToFiles(fileIds, tag, currentScanDate);
            try {
                filesWithScroll = this.service.getNextListWithScroll(filesWithScroll.getScrollId());
            }
            catch (IOException e) {
                log.error("Unable to get the next set of files with scroll, aborting current batch of transfer tag");
                break;
            }
        } while (filesWithScroll.getSize() > 0);
        this.service.clearScroll(filesWithScroll.getScrollId());
    }
}

