/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.utils;

import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.permission.ResourceFilterBuilder;
import io.dataintell.visionapi.security.AuthenticationHelper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Component;

@Component
public class ESFileQueryUtils {
    private final ResourceFilterBuilder resourceFilterBuilder;

    public ESFileQueryUtils(ResourceFilterBuilder resourceFilterBuilder) {
        this.resourceFilterBuilder = resourceFilterBuilder;
    }

    public SearchRequest getSearchRequest(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer from, Integer size, Boolean trackTotalHits, String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = this.getSearchSourceBuilder(searchQuery, fieldSort, sortDirection, from, size, trackTotalHits);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    public SearchRequest getSearchRequestWithAggregation(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer from, Integer size, Boolean trackTotalHits, List<AggregationBuilder> aggregationBuilders, String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = this.getSearchSourceBuilder(searchQuery, "_doc", sortDirection, from, size, trackTotalHits);
        for (AggregationBuilder aggregationBuilder : aggregationBuilders) {
            searchSourceBuilder.aggregation(aggregationBuilder);
        }
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    public SearchRequest getScrollSearchRequest(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer timeToLive, Integer size, String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(searchQuery).sort(this.getSortBuilder(fieldSort, sortDirection)).size(size.intValue());
        searchRequest.source(searchSourceBuilder).scroll(new TimeValue((long)timeToLive.intValue()));
        return searchRequest;
    }

    public BoolQueryBuilder getBasicBoolQueryBuilder(Boolean isDirectory, Boolean showOnlyDeletedFiles) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDirectory", (Object)isDirectory));
        if (showOnlyDeletedFiles == null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        } else if (showOnlyDeletedFiles.booleanValue()) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", true));
        }
        return boolQueryBuilder;
    }

    public static String getIndexName(LocalDate indexingDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return "file-" + indexingDate.format(formatter);
    }

    public SearchSourceBuilder getSearchSourceBuilder(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer from, Integer size, Boolean trackTotalHits) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(searchQuery).sort(this.getSortBuilder(fieldSort, sortDirection)).from(from.intValue()).size(size.intValue()).trackTotalHits(trackTotalHits.booleanValue());
        return searchSourceBuilder;
    }

    private SortBuilder getSortBuilder(String fieldSort, SortOrder sortDirection) {
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)fieldSort);
        sortBuilder.order(sortDirection);
        return sortBuilder;
    }
}

