/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.utils;

import io.dataintell.visionapi.domain.PeriodType;
import io.dataintell.visionapi.utils.DateUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class DateUtils {
    public static LocalDateTime getLocalDateTimeFromDouble(double date) {
        long milliseconds = (long)date;
        Instant instant = Instant.ofEpochMilli(milliseconds);
        return LocalDateTime.ofInstant(instant, ZoneId.of("America/New_York"));
    }

    public static LocalDate getPreviousLocalDate(LocalDate indexingDate, Boolean isMinusOperation, PeriodType type, Integer duration) {
        LocalDate previousDate;
        switch (1.$SwitchMap$io$dataintell$visionapi$domain$PeriodType[type.ordinal()]) {
            case 1: {
                if (isMinusOperation.booleanValue()) {
                    previousDate = indexingDate.minusWeeks(duration.intValue());
                    break;
                }
                previousDate = indexingDate.plusWeeks(duration.intValue());
                break;
            }
            case 2: {
                if (isMinusOperation.booleanValue()) {
                    previousDate = indexingDate.minusMonths(duration.intValue());
                    break;
                }
                previousDate = indexingDate.plusMonths(duration.intValue());
                break;
            }
            case 3: {
                if (isMinusOperation.booleanValue()) {
                    previousDate = indexingDate.minusYears(duration.intValue());
                    break;
                }
                previousDate = indexingDate.plusYears(duration.intValue());
                break;
            }
            default: {
                previousDate = isMinusOperation != false ? indexingDate.minusDays(duration.intValue()) : indexingDate.plusDays(duration.intValue());
            }
        }
        return previousDate;
    }
}

