/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.VolumeSetting;
import io.dataintell.visionapi.permission.ResourceType;
import io.dataintell.visionapi.problem.ElasticsearchIOException;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.PrivilegeRepository;
import io.dataintell.visionapi.repository.ProjectPathRepository;
import io.dataintell.visionapi.repository.VolumeSettingRepository;
import io.dataintell.visionapi.repository.elasticsearch.FileRepository;
import io.dataintell.visionapi.repository.elasticsearch.VolumeRepository;
import io.dataintell.visionapi.schedule.ScheduleService;
import io.dataintell.visionapi.schedule.job.ScanVolumesJob;
import io.dataintell.visionapi.schedule.job.SendVolumeSpaceAlertJob;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.service.ProjectService;
import io.dataintell.visionapi.utils.SortUtils;
import java.io.IOException;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManagerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class VolumeSettingService {
    private static final String VOLUMES = "volumes";
    private static final String RESOURCEIDS = "resourceIds";
    private final VolumeSettingRepository volumeSettingRepository;
    private final ProjectPathRepository projectPathRepository;
    private final ScheduleService scheduleService;
    private final PrivilegeRepository privilegeRepository;
    private final VolumeRepository volumeRepository;
    private final ProjectService projectService;
    private final IndexService indexService;
    private final FileRepository fileRepository;
    private final EntityManagerFactory entityManagerFactory;

    public VolumeSettingService(VolumeSettingRepository volumeSettingRepository, ProjectPathRepository projectPathRepository, ScheduleService scheduleService, PrivilegeRepository privilegeRepository, VolumeRepository volumeRepository, ProjectService projectService, IndexService indexService, FileRepository fileRepository, EntityManagerFactory entityManagerFactory) {
        this.volumeSettingRepository = volumeSettingRepository;
        this.projectPathRepository = projectPathRepository;
        this.scheduleService = scheduleService;
        this.privilegeRepository = privilegeRepository;
        this.volumeRepository = volumeRepository;
        this.projectService = projectService;
        this.indexService = indexService;
        this.fileRepository = fileRepository;
        this.entityManagerFactory = entityManagerFactory;
    }

    public PaginatedResult<VolumeSetting> getVolumeSettings(Integer page, Integer size, String sort, List<String> types) {
        String[] sortParameters = sort.split(",");
        Sort.Direction direction = SortUtils.getDirectionForSorting((String[])sortParameters);
        PaginatedResult volumeSettingPaginatedResult = new PaginatedResult();
        Page volumeSettings = types == null ? this.volumeSettingRepository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortParameters[0]}))) : this.volumeSettingRepository.findAllByTypeIn((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortParameters[0]})), types);
        volumeSettingPaginatedResult.setDirection(direction.name().toLowerCase());
        volumeSettingPaginatedResult.setSort(sortParameters[0]);
        volumeSettingPaginatedResult.setTotal(Long.valueOf(volumeSettings.getTotalElements()));
        volumeSettingPaginatedResult.setPage(Integer.valueOf(volumeSettings.getNumber() + 1));
        volumeSettingPaginatedResult.setSize(size);
        volumeSettingPaginatedResult.setElements(volumeSettings.getContent());
        return volumeSettingPaginatedResult;
    }

    public void createVolumeSetting(VolumeSetting volumeSetting) {
        volumeSetting.setPath(this.formatPath(volumeSetting.getPath()));
        this.volumeSettingRepository.save((Object)volumeSetting);
    }

    public void updateVolumeSetting(Long id, VolumeSetting volumeSetting) {
        VolumeSetting volumeSettingToUpdate = this.volumeSettingRepository.findById((Object)id).orElse(null);
        if (volumeSettingToUpdate == null) {
            throw new EntityNotFoundException(VolumeSetting.class, String.valueOf(id));
        }
        volumeSetting.setPath(this.formatPath(volumeSetting.getPath()));
        this.volumeSettingRepository.save((Object)volumeSetting);
    }

    @Transactional
    public void deleteVolumeSetting(Long id) {
        Optional latestScan = this.indexService.getMostRecentScanDate();
        Optional volumeSetting = this.volumeSettingRepository.findById((Object)id);
        if (volumeSetting.isPresent()) {
            this.removeVolumeIdFromJobs(id.intValue());
            List projectPaths = this.projectPathRepository.findByVolumeSetting((VolumeSetting)volumeSetting.get());
            projectPaths.forEach(pp -> this.projectPathRepository.deleteById((Object)pp.getId()));
            EntityManagerHolder entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.entityManagerFactory);
            if (entityManagerHolder != null) {
                entityManagerHolder.getEntityManager().flush();
            }
            this.privilegeRepository.deletePrivilegeEntitiesByResourceIdAndResourceType(id, ResourceType.VOLUME);
            if (latestScan.isPresent()) {
                this.projectService.indexAllProjects((LocalDate)latestScan.get());
                try {
                    this.fileRepository.deleteFilesFromLatestIndexingDate(id, (LocalDate)latestScan.get());
                    this.volumeRepository.deleteVolumeFromLastIndexingDate(id, (LocalDate)latestScan.get());
                }
                catch (IOException e) {
                    throw new ElasticsearchIOException();
                }
            }
            this.volumeSettingRepository.deleteById((Object)id);
        }
    }

    public List<Long> getVolumeSettingIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        List volumeSettingList = this.volumeSettingRepository.findAll();
        for (VolumeSetting volumeSetting : volumeSettingList) {
            ids.add(volumeSetting.getId());
        }
        return ids;
    }

    public VolumeSetting getVolumeSettingById(long id) {
        Optional volumeSetting = this.volumeSettingRepository.findById((Object)id);
        if (volumeSetting.isEmpty()) {
            throw new EntityNotFoundException(VolumeSetting.class, String.valueOf(id));
        }
        return (VolumeSetting)volumeSetting.get();
    }

    public List<VolumeSetting> getAllVolumesByServerIdAndType(long serverId, String type) {
        return this.volumeSettingRepository.findByServerIdAndType(serverId, type);
    }

    private String formatPath(String path) {
        return Paths.get(path, new String[0]).toString();
    }

    public List<VolumeSetting> getAllVolumesInIds(List<Long> volumeIds) {
        return this.volumeSettingRepository.findByIdIn(volumeIds);
    }

    private void removeVolumeIdFromJobs(int id) {
        List scanSchedules = this.scheduleService.getAllByJobClass(ScanVolumesJob.class.getName());
        List alertSchedules = this.scheduleService.getAllByJobClass(SendVolumeSpaceAlertJob.class.getName());
        scanSchedules.forEach(schedule -> {
            List ids = (List)schedule.getPayload().get(VOLUMES);
            if (ids.contains(id)) {
                if (ids.size() == 1) {
                    this.scheduleService.delete(schedule.getId().longValue());
                } else {
                    ids.remove((Object)id);
                    schedule.getPayload().replace(VOLUMES, ids);
                    this.scheduleService.update(schedule.getId().longValue(), schedule);
                }
            }
        });
        alertSchedules.forEach(schedule -> {
            List ids = (List)schedule.getPayload().get(RESOURCEIDS);
            if (ids.contains(id)) {
                if (ids.size() == 1) {
                    this.scheduleService.delete(schedule.getId().longValue());
                } else {
                    ids.remove((Object)id);
                    schedule.getPayload().replace(RESOURCEIDS, ids);
                    this.scheduleService.update(schedule.getId().longValue(), schedule);
                }
            }
        });
    }
}

