/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.PeriodType;
import io.dataintell.visionapi.domain.VariationGeneric;
import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.mapper.VolumeMapper;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.elasticsearch.VolumeRepository;
import io.dataintell.visionapi.service.VolumeSettingService;
import io.dataintell.visionapi.utils.DateUtils;
import io.dataintell.visionapi.utils.SortUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VolumeService {
    private static final Logger log = LoggerFactory.getLogger(VolumeService.class);
    private final VolumeRepository volumeRepository;
    private final VolumeMapper volumeMapper;
    private final VolumeSettingService volumeSettingService;

    public VolumeService(VolumeRepository volumeRepository, VolumeMapper volumeMapper, VolumeSettingService volumeSettingService) {
        this.volumeRepository = volumeRepository;
        this.volumeMapper = volumeMapper;
        this.volumeSettingService = volumeSettingService;
    }

    public Volume getVolumeById(long id) {
        SearchResponse response = (SearchResponse)this.volumeRepository.findById(Long.valueOf(id)).orElseThrow(this.notFound(id));
        List volumes = this.volumeMapper.convertToDto(response);
        return (Volume)volumes.get(0);
    }

    public PaginatedResult<Volume> getVolumeById(int page, int size, String sortField, String direction, long id, LocalDate from, LocalDate to) {
        SearchResponse response = (SearchResponse)this.volumeRepository.findVolumeHistoryById(page, size, sortField, direction, id, from, to).orElseThrow(this.notFound(id));
        return this.volumeMapper.getPaginatedResultWithSize(page, size, sortField, direction, response);
    }

    public PaginatedResult<Volume> getVolumes(Integer page, Integer size, String sort, LocalDate indexingDate) throws IOException {
        String[] sortParameters = sort.split(",");
        String sortField = sortParameters[0];
        SortOrder direction = SortUtils.getESDirectionForSorting((String[])sortParameters);
        Integer from = (page - 1) * size;
        SearchResponse response = this.volumeRepository.getAll(from, size, sortField, direction, this.getVolumeIdsAndIndexingDate(indexingDate), indexingDate);
        return this.volumeMapper.getPaginatedResult(page, sortField, direction.toString(), response);
    }

    public PaginatedResult<Volume> getMostRecentVolumes(Integer page, Integer size, String sort, String direction, LocalDate indexingDate) throws IOException {
        String[] sortParameters = sort.split(",");
        String sortField = sortParameters[0];
        Integer from = (page - 1) * size;
        List volumeSettingIds = this.volumeSettingService.getVolumeSettingIds();
        SearchResponse response = this.volumeRepository.getAllMostRecent(from, size, sortField, direction, this.getMostRecentVolumeIdsAndIndexingDate(indexingDate, volumeSettingIds), indexingDate, volumeSettingIds);
        return this.volumeMapper.getPaginatedResult(page, sortField, direction, response);
    }

    public PaginatedResult<Volume> getVolumesPerDay(Integer page, Integer size, String sort, LocalDate indexingDate) throws IOException {
        String[] sortParameters = sort.split(",");
        String sortField = sortParameters[0];
        SortOrder direction = SortUtils.getESDirectionForSorting((String[])sortParameters);
        Integer from = (page - 1) * size;
        SearchResponse response = this.volumeRepository.getVolumesPerDay(from, size, sortField, direction, indexingDate);
        return this.volumeMapper.getPaginatedResult(page, sortField, direction.toString(), response);
    }

    public void saveVolume(Volume volume) {
        this.volumeRepository.indexVolume(volume);
    }

    private HashMap<Long, Long> getVolumeIdsAndIndexingDate(LocalDate indexingDate) throws IOException {
        SearchResponse searchResponse = this.volumeRepository.getLatestVolumes(indexingDate);
        return this.volumeMapper.getVolumeAndIndexingDateAggregation(searchResponse);
    }

    private HashMap<Long, Long> getMostRecentVolumeIdsAndIndexingDate(LocalDate indexingDate, List<Long> volumeSettingIds) throws IOException {
        SearchResponse searchResponse = this.volumeRepository.getMostRecentVolumes(indexingDate, volumeSettingIds);
        return this.volumeMapper.getVolumeAndIndexingDateAggregation(searchResponse);
    }

    public List<VariationGeneric<Volume, Long>> getBiggestVariations(LocalDate indexingDate, Integer size, PeriodType type, Integer duration) throws IOException {
        PaginatedResult volumePaginatedResult = this.getVolumes(Integer.valueOf(1), size, "id", indexingDate);
        if (volumePaginatedResult.getElements().size() == 0) {
            return new ArrayList<VariationGeneric<Volume, Long>>();
        }
        LocalDate targetIndexingDate = DateUtils.getPreviousLocalDate((LocalDate)indexingDate, (Boolean)true, (PeriodType)type, (Integer)duration);
        HashMap dateVolumes = this.findAllDistinctIndexingDateNearDateForAllVolume(targetIndexingDate, size);
        ArrayList oldVolumes = new ArrayList();
        for (Map.Entry localDateListEntry : dateVolumes.entrySet()) {
            PaginatedResult oldPaginatedResult = this.getVolumes(Integer.valueOf(1), size, "id", (LocalDate)localDateListEntry.getKey());
            oldVolumes.addAll(oldPaginatedResult.getElements().stream().filter(v -> ((List)localDateListEntry.getValue()).contains(v.getId())).collect(Collectors.toList()));
        }
        return this.getIntersectionList(volumePaginatedResult.getElements(), oldVolumes, indexingDate);
    }

    private HashMap<LocalDate, List<Long>> findAllDistinctIndexingDateNearDateForAllVolume(LocalDate indexingDate, Integer size) throws IOException {
        SearchResponse searchResponse = this.volumeRepository.findAllDistinctIndexingDateNearDateForAllVolume(indexingDate, size);
        return this.volumeMapper.getVolumeIDsGroupByIndexingDateAggregation(searchResponse);
    }

    private List<VariationGeneric<Volume, Long>> getIntersectionList(List<Volume> list1, List<Volume> list2, LocalDate indexingDate) {
        ArrayList<VariationGeneric<Volume, Long>> intersectionList = new ArrayList<VariationGeneric<Volume, Long>>();
        for (Volume v1 : list1) {
            for (Volume v2 : list2) {
                if (!v1.getId().equals(v2.getId())) continue;
                Long variation = v1.getUsed() - v2.getUsed();
                LocalDate localDate1 = v1.getIndexingDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate localDate2 = v2.getIndexingDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                long intervalNumberOfDays = ChronoUnit.DAYS.between(localDate2, localDate1);
                VariationGeneric variationGeneric = new VariationGeneric((Object)variation, "used", (Object)v1, (Object)v2, indexingDate, Integer.valueOf((int)intervalNumberOfDays));
                if (intersectionList.contains(variationGeneric)) continue;
                intersectionList.add((VariationGeneric<Volume, Long>)variationGeneric);
            }
        }
        Comparator<VariationGeneric> volumeComparator = Comparator.comparing(VariationGeneric::getVariation, Comparator.reverseOrder());
        intersectionList.sort(volumeComparator);
        return intersectionList;
    }

    private Supplier<EntityNotFoundException> notFound(long id) {
        return () -> new EntityNotFoundException(Volume.class, String.valueOf(id));
    }
}

