/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.ResetPasswordRequest;
import io.dataintell.visionapi.domain.ResetPasswordRequestByUser;
import io.dataintell.visionapi.domain.Role;
import io.dataintell.visionapi.domain.RoleType;
import io.dataintell.visionapi.domain.User;
import io.dataintell.visionapi.domain.UserCreation;
import io.dataintell.visionapi.entity.RoleEntity;
import io.dataintell.visionapi.entity.UserEntity;
import io.dataintell.visionapi.problem.BadRequestException;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.InvalidPasswordException;
import io.dataintell.visionapi.problem.OperationForbiddenException;
import io.dataintell.visionapi.problem.UniqueConstraintException;
import io.dataintell.visionapi.repository.RoleRepository;
import io.dataintell.visionapi.repository.UserRepository;
import io.dataintell.visionapi.schedule.JobGroup;
import io.dataintell.visionapi.schedule.ScheduleService;
import io.dataintell.visionapi.security.AuthenticationHelper;
import io.dataintell.visionapi.service.EmailService;
import io.dataintell.visionapi.utils.SortUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final PasswordEncoder passwordEncoder;
    private final ScheduleService scheduleService;
    private final EmailService emailService;
    private final AuthenticationManager authenticationManager;

    public UserService(UserRepository userRepository, RoleRepository roleRepository, PasswordEncoder passwordEncoder, ScheduleService scheduleService, AuthenticationManager authenticationManager, EmailService emailService) {
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.passwordEncoder = passwordEncoder;
        this.scheduleService = scheduleService;
        this.emailService = emailService;
        this.authenticationManager = authenticationManager;
    }

    public PaginatedResult<User> getUsers_v1(Integer page, Integer size, String sort) {
        String[] sortParameters = sort.split(",");
        Sort.Direction direction = SortUtils.getDirectionForSorting((String[])sortParameters);
        Page users = this.userRepository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortParameters[0]}))).map(arg_0 -> this.toDto(arg_0));
        return new PaginatedResult(users, direction.name().toLowerCase(), sortParameters[0], size);
    }

    public User createUser_v1(UserCreation user) {
        this.validate(user);
        UserEntity entity = new UserEntity(user.getName(), user.getUsername(), user.getEmail(), this.passwordEncoder.encode((CharSequence)user.getPassword()), Boolean.valueOf(false));
        entity.setRoleEntities(this.getRoles(user.getRoles()));
        User newUser = this.toDto((UserEntity)this.userRepository.save((Object)entity));
        this.emailService.sendEmailForNewUser(user.getUsername(), user.getPassword(), user.getEmail(), user.getName());
        return newUser;
    }

    public User updateUser_v1(Long id, User user) {
        UserEntity userToUpdate = (UserEntity)this.userRepository.findById((Object)id).orElseThrow(this.notFound(id));
        userToUpdate.setName(user.getName());
        userToUpdate.setEmail(user.getEmail());
        userToUpdate.setRoleEntities(this.getRoles(user.getRoles()));
        userToUpdate.setUsername(user.getUsername());
        return this.toDto((UserEntity)this.userRepository.save((Object)userToUpdate));
    }

    public User updateProfile(User user) {
        Long currentUserId = AuthenticationHelper.getCurrentUserId();
        UserEntity userToUpdate = (UserEntity)this.userRepository.findById((Object)currentUserId).orElseThrow(this.notFound(currentUserId));
        userToUpdate.setName(user.getName());
        userToUpdate.setEmail(user.getEmail());
        userToUpdate.setUsername(user.getUsername());
        if (user.getEulaValidation() != null) {
            userToUpdate.setEulaValidation(user.getEulaValidation());
        }
        return this.toDto((UserEntity)this.userRepository.save((Object)userToUpdate));
    }

    public void deleteUser(Long id) {
        User user = this.getUserById_v1(id.longValue());
        List adminRoles = user.getRoles().stream().filter(role -> role.getName().equals(ROLE_ADMIN)).collect(Collectors.toList());
        if (!adminRoles.isEmpty()) {
            throw new OperationForbiddenException("Cannot delete administrator!");
        }
        this.userRepository.deleteById((Object)id);
        List schedules = this.scheduleService.getAll(Optional.of(JobGroup.ALERT.name()), Optional.of(id.intValue()));
        schedules.forEach(s -> this.scheduleService.delete(s.getId().longValue()));
    }

    public User getUserById_v1(long id) {
        return this.userRepository.findById((Object)id).map(arg_0 -> this.toDto(arg_0)).orElseThrow(this.notFound(Long.valueOf(id)));
    }

    public void resetPassword(Long userId, ResetPasswordRequest resetPasswordRequest) {
        UserEntity userToUpdate = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(this.notFound(userId));
        if (!resetPasswordRequest.getNewPassword().equals(resetPasswordRequest.getConfirmPassword())) {
            throw new BadRequestException("New password and confirm password do not match");
        }
        userToUpdate.setPassword(this.passwordEncoder.encode((CharSequence)resetPasswordRequest.getNewPassword()));
        this.userRepository.save((Object)userToUpdate);
    }

    public void resetPasswordByUser(ResetPasswordRequestByUser resetPasswordRequestByUser) {
        String currentUsername = AuthenticationHelper.getCurrentUsername();
        String currentPassword = resetPasswordRequestByUser.getCurrentPassword();
        Long currentUserId = AuthenticationHelper.getCurrentUserId();
        try {
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)currentUsername, (Object)currentPassword));
        }
        catch (AuthenticationException e) {
            throw new InvalidPasswordException("does not match", "currentPassword", currentPassword);
        }
        if (resetPasswordRequestByUser.getNewPassword().equals(currentPassword)) {
            throw new InvalidPasswordException("should not be the same as current password ", "newPassword", resetPasswordRequestByUser.getNewPassword());
        }
        UserEntity userToUpdate = (UserEntity)this.userRepository.findById((Object)currentUserId).orElseThrow(this.notFound(currentUserId));
        if (!resetPasswordRequestByUser.getNewPassword().equals(resetPasswordRequestByUser.getConfirmPassword())) {
            throw new InvalidPasswordException("does not match new password", "confirmPassword", resetPasswordRequestByUser.getConfirmPassword());
        }
        userToUpdate.setPassword(this.passwordEncoder.encode((CharSequence)resetPasswordRequestByUser.getNewPassword()));
        this.userRepository.save((Object)userToUpdate);
    }

    public User addRole(Long userId, Long roleId) {
        UserEntity entityToUpdate = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(this.notFound(userId));
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.findById((Object)roleId).orElseThrow(this.notFound(roleId));
        entityToUpdate.getRoleEntities().add(roleEntity);
        return this.toDto((UserEntity)this.userRepository.save((Object)entityToUpdate));
    }

    public User removeRole(Long userId, Long roleId) {
        UserEntity entityToUpdate = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(this.notFound(userId));
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.findById((Object)roleId).orElseThrow(this.notFound(roleId));
        entityToUpdate.getRoleEntities().remove(roleEntity);
        return this.toDto((UserEntity)this.userRepository.save((Object)entityToUpdate));
    }

    private List<RoleEntity> getRoles(List<Role> roles) {
        ArrayList<RoleEntity> userRoleEntities = new ArrayList<RoleEntity>();
        if (roles == null) {
            return userRoleEntities;
        }
        for (Role role : roles) {
            userRoleEntities.add((RoleEntity)this.roleRepository.findById((Object)role.getId()).orElseThrow(() -> new EntityNotFoundException(RoleEntity.class)));
        }
        return userRoleEntities;
    }

    private Supplier<EntityNotFoundException> notFound(Long id) {
        return () -> new EntityNotFoundException(UserEntity.class, String.valueOf(id));
    }

    private void validate(UserCreation userRequest) {
        if (!this.isValidPwd(userRequest.getPassword())) {
            throw new BadRequestException("Invalid password!");
        }
        if (this.userRepository.existsByUsername(userRequest.getUsername()).booleanValue()) {
            throw new UniqueConstraintException(User.class, "username", userRequest.getUsername());
        }
        if (this.userRepository.existsByEmail(userRequest.getEmail()).booleanValue()) {
            throw new UniqueConstraintException(User.class, "email", userRequest.getEmail());
        }
    }

    private User toDto(UserEntity entity) {
        List<Object> roles = new ArrayList();
        if (null != entity.getRoleEntities()) {
            roles = entity.getRoleEntities().stream().map(r -> Role.builder().id(r.getId()).name(r.getName()).description(r.getDescription()).type(RoleType.valueOf((String)r.getType())).build()).collect(Collectors.toList());
        }
        return User.builder().id(entity.getId()).name(entity.getName()).username(entity.getUsername()).email(entity.getEmail()).eulaValidation(entity.getEulaValidation()).roles(roles).build();
    }

    private boolean isValidPwd(String password) {
        return password.length() >= 6 && password.length() <= 20;
    }
}

