/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.StoragePrice;
import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.entity.StoragePriceEntity;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.SQLDeleteForeignKeyConstraintException;
import io.dataintell.visionapi.repository.StoragePriceRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class StoragePriceService {
    private final StoragePriceRepository repository;

    public StoragePriceService(StoragePriceRepository repository) {
        this.repository = repository;
    }

    public StoragePrice create(StoragePrice storagePrice) {
        StoragePriceEntity entity = (StoragePriceEntity)this.repository.save((Object)this.toEntity(storagePrice));
        return this.toDTO(entity);
    }

    public StoragePrice findById(int id) {
        Optional optionalStoragePrice = this.repository.findById((Object)id);
        if (optionalStoragePrice.isPresent()) {
            return this.toDTO((StoragePriceEntity)optionalStoragePrice.get());
        }
        throw new EntityNotFoundException(StoragePriceEntity.class, String.valueOf(id));
    }

    public List<StoragePrice> findAll() {
        List all = (List)this.repository.findAll();
        return all.stream().map(arg_0 -> this.toDTO(arg_0)).collect(Collectors.toList());
    }

    public void delete(int id) {
        this.repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(StoragePriceEntity.class, String.valueOf(id)));
        try {
            this.repository.deleteById((Object)id);
        }
        catch (DataIntegrityViolationException e) {
            throw new SQLDeleteForeignKeyConstraintException(StoragePriceEntity.class, String.valueOf(id), Volume.class);
        }
    }

    public StoragePrice update(int id, StoragePrice storagePrice) throws EntityNotFoundException {
        Optional optional = this.repository.findById((Object)id);
        if (optional.isPresent()) {
            StoragePriceEntity toUpdate = (StoragePriceEntity)optional.get();
            toUpdate.setPrice(storagePrice.getPrice());
            toUpdate.setDescription(storagePrice.getDescription());
            toUpdate.setCurrencySymbol(storagePrice.getCurrencySymbol());
            return this.toDTO((StoragePriceEntity)this.repository.save((Object)toUpdate));
        }
        throw new EntityNotFoundException(StoragePriceEntity.class, String.valueOf(id));
    }

    private StoragePriceEntity toEntity(StoragePrice storagePrice) {
        StoragePriceEntity entity = new StoragePriceEntity();
        entity.setCurrencySymbol(storagePrice.getCurrencySymbol());
        entity.setDescription(storagePrice.getDescription());
        entity.setPrice(storagePrice.getPrice());
        return entity;
    }

    private StoragePrice toDTO(StoragePriceEntity entity) {
        StoragePrice dto = new StoragePrice();
        dto.setId(entity.getId());
        dto.setCurrencySymbol(entity.getCurrencySymbol());
        dto.setDescription(entity.getDescription());
        dto.setPrice(entity.getPrice());
        return dto;
    }
}

