/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.PeriodType;
import io.dataintell.visionapi.domain.Statistic;
import io.dataintell.visionapi.mapper.StatisticMapper;
import io.dataintell.visionapi.repository.elasticsearch.FileRepository;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.utils.DateUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

@Service
public class StatisticService {
    private final FileRepository fileRepository;
    private final IndexService indexService;
    private final StatisticMapper statisticMapper;

    public StatisticService(FileRepository fileRepository, IndexService indexService, StatisticMapper statisticMapper) {
        this.fileRepository = fileRepository;
        this.indexService = indexService;
        this.statisticMapper = statisticMapper;
    }

    public Statistic getDuplicatesStatistic(LocalDate indexingDate) throws IOException {
        SearchResponse searchResponse = this.fileRepository.getDuplicateFiles(indexingDate);
        return this.statisticMapper.convertToDto(searchResponse, "Duplicate files", indexingDate);
    }

    public List<Statistic> getDuplicatesStatistics(LocalDate indexingDate, Integer numberOfDays) {
        List dates = this.indexService.getAllScanDates();
        return dates.parallelStream().filter(date -> date.isBefore(indexingDate) || date.isEqual(indexingDate)).limit(numberOfDays.intValue()).map(d -> {
            try {
                return this.getDuplicatesStatistic(d);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }

    public Statistic getFilesNotUsedInPreviousPeriodStatistic(LocalDate indexingDate, PeriodType type, Integer duration) throws IOException {
        LocalDate previousDate = DateUtils.getPreviousLocalDate((LocalDate)indexingDate, (Boolean)true, (PeriodType)type, (Integer)duration);
        SearchResponse searchResponse = this.fileRepository.getTotalFileSizeAccessBefore(Date.from(previousDate.atStartOfDay(ZoneId.systemDefault()).toInstant()), indexingDate);
        return this.statisticMapper.convertToDto(searchResponse, "Files not used", indexingDate);
    }

    public List<Statistic> getFilesNotUsedInPreviousPeriod(LocalDate indexingDate, PeriodType type, Integer duration, Integer size) {
        List dates = this.indexService.getAllScanDates();
        return dates.parallelStream().filter(date -> date.isBefore(indexingDate) || date.isEqual(indexingDate)).limit(size.intValue()).map(d -> {
            try {
                return this.getFilesNotUsedInPreviousPeriodStatistic(d, type, duration);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }

    public Statistic getByLastAccess(Date date, LocalDate indexingDate) throws IOException {
        SearchResponse searchResponse = this.fileRepository.getTotalFileSizeAccessBefore(date, indexingDate);
        return this.statisticMapper.convertToDto(searchResponse, "Last Access", indexingDate);
    }

    public List<Statistic> getByPathList(List<String> paths, Boolean onlyDuplicate, Date lastAccess, LocalDate indexingDate) {
        return paths.parallelStream().map(path -> {
            try {
                return this.statisticMapper.convertToDto(this.fileRepository.getFilesOfDirectories(Collections.singletonList(path), null, onlyDuplicate, Boolean.valueOf(false), lastAccess, Integer.valueOf(0), Integer.valueOf(0), "size", SortOrder.DESC, Boolean.valueOf(true), indexingDate), path, indexingDate);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }
}

