/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.entity.Server;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.OperationForbiddenException;
import io.dataintell.visionapi.problem.UniqueConstraintException;
import io.dataintell.visionapi.repository.ServerRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class ServerService {
    private static final Logger logger = LoggerFactory.getLogger(ServerService.class);
    private final ServerRepository serverRepository;

    public ServerService(ServerRepository serverRepository) {
        this.serverRepository = serverRepository;
    }

    public Server getServerById(long id) {
        logger.debug("Getting server with id [{}]", (Object)id);
        return (Server)this.serverRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(Server.class, String.valueOf(id)));
    }

    public Server updateServer(Long id, Server server) {
        logger.info("Updating server with id[{}], name[{}]", (Object)id, (Object)server.getName());
        this.getServerById(id.longValue());
        server.setId(id);
        return this.save(server);
    }

    public Server createServer(Server server) {
        logger.info("Creating server with name [{}]", (Object)server.getName());
        return this.save(server);
    }

    public List<Server> getAllServers() {
        return (List)this.serverRepository.findAll();
    }

    public void deleteServer(Long id) {
        if (1L == id) {
            throw new OperationForbiddenException("Cannot delete main server");
        }
        Server server = this.getServerById(id.longValue());
        logger.info("Deleting Server with id[{}] and name[{}]", (Object)id, (Object)server.getName());
        this.serverRepository.deleteById((Object)id);
    }

    private Server save(Server server) {
        try {
            return (Server)this.serverRepository.save((Object)server);
        }
        catch (DataIntegrityViolationException e) {
            throw new UniqueConstraintException(Server.class, "name", server.getName());
        }
    }
}

