/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.Direction;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.ScrollResult;
import io.dataintell.visionapi.domain.search.SearchFilter;
import io.dataintell.visionapi.mapper.FileMapper;
import io.dataintell.visionapi.problem.ElasticsearchIOException;
import io.dataintell.visionapi.repository.elasticsearch.FileSearchRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

@Service
public class SearchService {
    private final FileSearchRepository fileSearchRepository;
    private final FileMapper fileMapper;

    public SearchService(FileSearchRepository fileSearchRepository, FileMapper fileMapper) {
        this.fileSearchRepository = fileSearchRepository;
        this.fileMapper = fileMapper;
    }

    public PaginatedResult<File> search(LocalDate indexingDate, Integer page, Integer size, String sort, Direction direction, List<SearchFilter> searchFilters) {
        SortOrder sortOrder = SortOrder.valueOf((String)direction.name());
        Optional searchResponse = this.fileSearchRepository.search(indexingDate, Integer.valueOf((page - 1) * size), size, sort, sortOrder, searchFilters);
        return searchResponse.map(response -> this.fileMapper.getPaginatedResultWithSize(page.intValue(), size.intValue(), sort, sortOrder.name(), response)).orElseThrow(this.elasticsearchIOException());
    }

    public ScrollResult<File> searchWithDeepPagination(LocalDate indexingDate, String scrollId, Integer size, String sort, Direction direction, List<SearchFilter> searchFilters) {
        Optional searchResponse;
        if (scrollId != null) {
            searchResponse = this.fileSearchRepository.searchAfterWithScroll(scrollId);
        } else {
            SortOrder sortOrder = SortOrder.valueOf((String)direction.name());
            searchResponse = this.fileSearchRepository.searchWithScroll(indexingDate, size, sort, sortOrder, searchFilters);
        }
        return searchResponse.map(arg_0 -> ((FileMapper)this.fileMapper).getScrollResult(arg_0)).orElseThrow(this.elasticsearchIOException());
    }

    public Supplier<ElasticsearchIOException> elasticsearchIOException() {
        return ElasticsearchIOException::new;
    }
}

