/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.config.ThreadPoolConfig;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.entity.VolumeSetting;
import io.dataintell.visionapi.file.BulkProcessorFactory;
import io.dataintell.visionapi.file.FileService;
import io.dataintell.visionapi.file.IngestFileProcessor;
import io.dataintell.visionapi.legacyscanner.FileBuilder;
import io.dataintell.visionapi.legacyscanner.FolderToScan;
import io.dataintell.visionapi.legacyscanner.FullScanVisitor;
import io.dataintell.visionapi.legacyscanner.InitialScanVisitor;
import io.dataintell.visionapi.legacyscanner.PathScan;
import io.dataintell.visionapi.legacyscanner.ScanQueue;
import io.dataintell.visionapi.legacyscanner.VolumeBuilder;
import io.dataintell.visionapi.legacyscanner.VolumeScan;
import io.dataintell.visionapi.scanner.DeletedFilesManager;
import io.dataintell.visionapi.scanner.DuplicateFilesManager;
import io.dataintell.visionapi.scanner.JobService;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.service.ProjectService;
import io.dataintell.visionapi.service.VolumeService;
import io.dataintell.visionapi.service.VolumeSettingService;
import io.dataintell.visionapi.utils.TransferTagsManager;
import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class ScanService {
    @Autowired
    VolumeSettingService volumeSettingService;
    @Autowired
    FileBuilder fileBuilder;
    @Autowired
    VolumeBuilder volumeBuilder;
    @Autowired
    FileService fileService;
    @Autowired
    VolumeService volumeService;
    @Autowired
    IndexService indexService;
    @Autowired
    DeletedFilesManager deletedFilesManager;
    @Autowired
    ProjectService projectService;
    @Autowired
    DuplicateFilesManager duplicateFilesManager;
    @Autowired
    ThreadPoolConfig threadPoolConfig;
    @Autowired
    JobService jobService;
    @Autowired
    BulkProcessorFactory bulkProcessorFactory;
    @Autowired
    TransferTagsManager transferTagsManager;
    @Value(value="${dataintell.server.useRemoteScanners}")
    private Boolean useRemoteScanners;
    @Value(value="${dataintell.scanner.multithread.folder.depth}")
    private Integer multithreadFolderDepth;
    private static final Logger logger = LoggerFactory.getLogger(ScanService.class);
    private boolean isScanning = false;

    @Deprecated
    public void scanVolume(Long volumeId, Boolean cloneIndex, LocalDate indexingDate) throws Exception {
        LocalDate currentScanDate = LocalDate.now();
        List pastScanDate = this.indexService.getAllScanDates();
        boolean isFirstScanOfTheDay = this.isFirstScanOfTheDay(currentScanDate);
        VolumeSetting volumeSetting = this.volumeSettingService.getVolumeSettingById(volumeId.longValue());
        this.createIndices(indexingDate, cloneIndex.booleanValue());
        this.scanVolumes(Collections.singletonList(volumeSetting), indexingDate, isFirstScanOfTheDay);
        this.indexService.refreshFileIndex(indexingDate);
        if (isFirstScanOfTheDay) {
            this.transferTagsManager.transferTagsToNextScanDate((LocalDate)pastScanDate.get(0), currentScanDate);
        }
        this.duplicateFilesManager.tagDuplicatedFilesForVolumesAfterDeltaScan(List.of(volumeId), indexingDate);
        this.indexService.refreshFileIndex(indexingDate);
        this.projectService.indexAllProjects(indexingDate);
        this.isScanning = false;
    }

    public void indexListOfFiles(List<File> files, LocalDate indexingDate) {
        this.preScanJob(false, indexingDate);
        Set foldersToUpdate = this.fileService.indexFiles(files, indexingDate);
        this.indexService.refreshFileIndex(indexingDate);
        this.fileService.updateParentFolders(foldersToUpdate, indexingDate);
        this.indexService.refreshFileIndex(indexingDate);
    }

    @Deprecated
    public void scanAll(Boolean cloneIndex, LocalDate indexingDate) throws Exception {
        if (this.useRemoteScanners.booleanValue()) {
            this.jobService.dispatchScanAll(cloneIndex.booleanValue());
        } else {
            logger.info("About to scan everything");
            Date scanDate = new Date();
            LocalDate currentScanDate = LocalDate.now();
            List pastScanDate = this.indexService.getAllScanDates();
            boolean isFirstScanOfTheDay = this.isFirstScanOfTheDay(currentScanDate);
            long start = System.currentTimeMillis();
            this.preScanJob(cloneIndex.booleanValue(), indexingDate);
            List volumeSettingEntities = this.volumeSettingService.getAllVolumesByServerIdAndType(1L, "crawl.files");
            this.scanVolumes(volumeSettingEntities, indexingDate, isFirstScanOfTheDay);
            this.indexService.refreshFileIndex(indexingDate);
            List volumeIds = volumeSettingEntities.stream().map(VolumeSetting::getId).collect(Collectors.toList());
            if (isFirstScanOfTheDay) {
                this.transferTagsManager.transferTagsToNextScanDate((LocalDate)pastScanDate.get(0), currentScanDate);
                this.deletedFilesManager.tagDeletedFilesForVolumesAfterFullScan(volumeSettingEntities.stream().map(VolumeSetting::getId).collect(Collectors.toList()), scanDate, indexingDate);
                this.duplicateFilesManager.tagDuplicatedFilesForVolumesAfterFullScanForOnPremise(volumeIds, indexingDate);
            } else {
                this.deletedFilesManager.tagDeletedFilesForVolumesAfterDeltaScan(volumeSettingEntities, scanDate, indexingDate);
                this.duplicateFilesManager.tagDuplicatedFilesForVolumesAfterDeltaScan(volumeIds, indexingDate);
            }
            this.indexService.refreshFileIndex(indexingDate);
            this.postScanJob(indexingDate);
            long time = System.currentTimeMillis() - start;
            this.isScanning = false;
            logger.info(String.format("Scanning everything took %s ms", time));
        }
    }

    public void postScanJob(LocalDate indexingDate) {
        this.indexService.refreshFileIndex(indexingDate);
        this.projectService.indexAllProjects(indexingDate);
    }

    public void preScanJob(boolean cloneIndex, LocalDate indexingDate) {
        try {
            this.createIndices(indexingDate, cloneIndex);
            this.projectService.indexAllProjects(indexingDate);
        }
        catch (IOException | InterruptedException | NotFoundException e) {
            logger.error("Unable to create indices for indexingDate[{}], cloneIndex[{}]", new Object[]{indexingDate, cloneIndex, e});
        }
    }

    private void scanPath(VolumeSetting volumeSetting, FolderToScan folderToScan, ScanQueue scanQueue, Date lastScan) {
        try {
            Date newLastScan = folderToScan.isFullScan() ? null : lastScan;
            FullScanVisitor fullScanVisitor = new FullScanVisitor(this.fileBuilder, scanQueue, volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath(), folderToScan.toString(), newLastScan);
            Files.walkFileTree(folderToScan.getPath(), (FileVisitor<? super Path>)fullScanVisitor);
        }
        catch (Exception e) {
            logger.error(String.format("Error while crawling path [%s] of volume [%s] with id [%s] and mount path [%s]", folderToScan, volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath()), (Throwable)e);
        }
    }

    private void finishVolumeScan(VolumeSetting volumeSetting, ScanQueue scanQueue, long startTime, Volume volume, Date lastScan, LocalDate indexingDate) {
        Date scanDate = new Date(startTime);
        FullScanVisitor fullScanVisitor = new FullScanVisitor(this.fileBuilder, scanQueue, volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath(), volumeSetting.getPath(), lastScan);
        HashSet<FileVisitOption> fileVisitOptions = new HashSet<FileVisitOption>();
        try {
            logger.info(String.format("About to finish the scan of volume id [%s] with the path [%s]", volumeSetting.getId(), volumeSetting.getPath()));
            Files.walkFileTree(Paths.get(volumeSetting.getPath(), new String[0]), fileVisitOptions, this.multithreadFolderDepth - 1, (FileVisitor<? super Path>)fullScanVisitor);
            scanQueue.emptyDirectoryQueue();
        }
        catch (Exception e) {
            logger.error(String.format("Unable to finish the scan of the volume [%s] with path [%s]", volumeSetting.getId(), volumeSetting.getPath()), (Throwable)e);
        }
        long time = System.currentTimeMillis() - startTime;
        volumeSetting.setLastScan(this.getScanDate(scanDate, indexingDate));
        this.volumeSettingService.updateVolumeSetting(volumeSetting.getId(), volumeSetting);
        volume.setCrawlDuration(Long.valueOf(time));
        this.saveVolume(volume);
        logger.info(String.format("Crawling files of volume %s with id %s and path %s took %s ms", volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath(), time));
    }

    @Deprecated
    private void scanVolumes(List<VolumeSetting> volumeSettingEntities, LocalDate indexingDate, boolean isFirstScanOfTheDay) throws InterruptedException {
        if (this.isScanning) {
            logger.error("Scanning request rejected, already scanning!");
            throw new HttpClientErrorException(HttpStatus.CONFLICT);
        }
        this.isScanning = true;
        IngestFileProcessor ingestFileProcessor = new IngestFileProcessor(this.bulkProcessorFactory.makeBulkProcessor(), indexingDate, isFirstScanOfTheDay);
        List volumeScans = this.getVolumeScansForVolumes(volumeSettingEntities, indexingDate, ingestFileProcessor);
        ConcurrentHashMap volumesPathsCount = new ConcurrentHashMap();
        volumeScans.forEach(v -> {
            ConcurrentSet pathSet = new ConcurrentSet();
            v.getPathList().forEach(p -> pathSet.add((Object)p.toString()));
            volumesPathsCount.put(v.getVolumeSetting().getId(), pathSet);
        });
        List paths = this.getPathScans(volumeScans);
        ArrayList callables = new ArrayList();
        paths.forEach(pathScan -> callables.add(() -> {
            this.scanPath(pathScan.getVolumeSetting(), pathScan.getFolderToScan(), pathScan.getScanQueue(), pathScan.getLastScanDate());
            Long volumeId = pathScan.getVolumeSetting().getId();
            ConcurrentSet pathSet = (ConcurrentSet)volumesPathsCount.get(volumeId);
            pathSet.remove((Object)pathScan.getFolderToScan().toString());
            if (pathSet.size() == 0) {
                this.finishVolumeScan(pathScan.getVolumeSetting(), pathScan.getScanQueue(), pathScan.getStartTime(), pathScan.getVolume(), pathScan.getLastScanDate(), indexingDate);
            }
            return true;
        }));
        this.threadPoolConfig.getExecutor().invokeAll(callables).forEach(future -> {
            try {
                future.isDone();
            }
            catch (Exception e) {
                logger.error("There was an error while scanning all volumes", (Throwable)e);
            }
        });
        ingestFileProcessor.closeIngestProcessor();
    }

    private List<VolumeScan> getVolumeScansForVolumes(List<VolumeSetting> volumeSettings, LocalDate indexingDate, IngestFileProcessor ingestFileProcessor) {
        ArrayList volumeScanOperations = new ArrayList();
        volumeSettings.forEach(volumeSetting -> volumeScanOperations.add(() -> this.getVolumeScan(volumeSetting, indexingDate, ingestFileProcessor)));
        ArrayList<VolumeScan> volumeScans = new ArrayList<VolumeScan>();
        try {
            this.threadPoolConfig.getExecutor().invokeAll(volumeScanOperations).forEach(future -> {
                try {
                    if (future.get() != null) {
                        volumeScans.add((VolumeScan)future.get());
                    }
                }
                catch (Exception e) {
                    logger.error("There was an error while getting the volume scan for a volume", (Throwable)e);
                }
            });
        }
        catch (InterruptedException e) {
            logger.error("There was an error with the multi-thread call to get volumeScan", (Throwable)e);
        }
        return volumeScans;
    }

    private List<PathScan> getPathScans(List<VolumeScan> volumeScans) {
        ArrayList<PathScan> paths = new ArrayList<PathScan>();
        int emptyList = 0;
        int index = 0;
        while (volumeScans.size() != emptyList) {
            int pathSize = volumeScans.get(index).getPathList().size();
            if (pathSize == 1) {
                ++emptyList;
            }
            if (pathSize > 0) {
                FolderToScan path = (FolderToScan)volumeScans.get(index).getPathList().get(0);
                paths.add(new PathScan(path, volumeScans.get(index).getFileQueue(), volumeScans.get(index).getVolumeSetting(), volumeScans.get(index).getStartTime(), volumeScans.get(index).getVolume(), volumeScans.get(index).getLastScanDate()));
                volumeScans.get(index).getPathList().remove(0);
            }
            index = index == volumeScans.size() - 1 ? 0 : index + 1;
        }
        return paths;
    }

    private VolumeScan getVolumeScan(VolumeSetting volumeSetting, LocalDate indexingDate, IngestFileProcessor ingestFileProcessor) {
        Volume volume = new Volume();
        VolumeScan volumeScan = new VolumeScan();
        try {
            Date scanDate = new Date();
            volume = this.volumeBuilder.createVolume(volumeSetting, scanDate, indexingDate);
            this.saveVolume(volume);
            Date lastScan = this.isFullScanNeeded(volumeSetting, scanDate) ? null : volumeSetting.getLastScan();
            volumeScan.setLastScanDate(lastScan);
            ScanQueue scanQueue = new ScanQueue(ingestFileProcessor);
            logger.info(String.format("About to scan volume [%s] with path [%s] and id [%s] for changes since [%s]", volumeSetting.getName(), volumeSetting.getPath(), volumeSetting.getId(), lastScan));
            long start = System.currentTimeMillis();
            List pathsToScan = this.getPathsToScan(volumeSetting, scanQueue, lastScan);
            volumeScan.setStartTime(start);
            volumeScan.setVolumeSetting(volumeSetting);
            volumeScan.setFileQueue(scanQueue);
            volumeScan.setPathList(pathsToScan);
            volumeScan.setVolume(volume);
            if (pathsToScan.size() == 0) {
                this.finishVolumeScan(volumeSetting, scanQueue, start, volume, lastScan, indexingDate);
                return null;
            }
        }
        catch (Exception e) {
            logger.error(String.format("Error while crawling files of volume %s with id %s and path %s", volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath()), (Throwable)e);
            volume.setCrawlDuration(Long.valueOf(-1L));
            this.saveVolume(volume);
            return null;
        }
        return volumeScan;
    }

    private List<FolderToScan> getPathsToScan(VolumeSetting volumeSetting, ScanQueue scanQueue, Date lastScan) throws IOException {
        Path volumeMountPoint = Paths.get(volumeSetting.getPath(), new String[0]);
        InitialScanVisitor initialScanVisitor = new InitialScanVisitor(this.fileBuilder, scanQueue, volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath(), lastScan, this.multithreadFolderDepth);
        HashSet<FileVisitOption> fileVisitOptions = new HashSet<FileVisitOption>();
        Files.walkFileTree(volumeMountPoint, fileVisitOptions, this.multithreadFolderDepth, (FileVisitor<? super Path>)initialScanVisitor);
        return initialScanVisitor.getPaths();
    }

    private boolean isFullScanNeeded(VolumeSetting volumeSetting, Date scanDate) {
        LocalDate currentScanDate;
        Date lastScan = volumeSetting.getLastScan();
        if (lastScan == null) {
            return true;
        }
        LocalDate lastScanDate = lastScan.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (!lastScanDate.equals(currentScanDate = scanDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
            return true;
        }
        boolean deltaDataExist = false;
        try {
            PaginatedResult result = this.fileService.searchFiles("", Boolean.valueOf(false), Collections.singletonList(volumeSetting.getId()), null, null, null, null, null, null, null, null, null, null, Integer.valueOf(1), Integer.valueOf(1), "indexingDate,desc", null, null, null, null, null, null, Boolean.valueOf(true), null, null, null, null, lastScanDate);
            deltaDataExist = result.getElements().size() > 0 && ((File)result.getElements().get(0)).getIndexingDate().after(lastScan);
        }
        catch (Exception e) {
            logger.error("There was an error while validating the last scan. The scan will be a complete scan", (Throwable)e);
        }
        return !deltaDataExist;
    }

    private void saveVolume(Volume volume) {
        try {
            this.volumeService.saveVolume(volume);
        }
        catch (Exception e) {
            logger.error("Unable to save volume", (Throwable)e);
        }
    }

    private void createIndices(LocalDate indexingDate, boolean cloneIndex) throws InterruptedException, NotFoundException, IOException {
        this.indexService.createFileIndex(indexingDate, cloneIndex);
        this.indexService.createIndex(IndexType.VOLUME, indexingDate);
        this.indexService.createIndex(IndexType.PROJECT, indexingDate);
    }

    private Date getScanDate(Date scanDate, LocalDate indexingDate) {
        Date newIndexingDate = scanDate;
        LocalDate scanDateFormatted = scanDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (!scanDateFormatted.equals(indexingDate)) {
            newIndexingDate = Date.from(indexingDate.atTime(23, 59, 0).atZone(ZoneId.systemDefault()).toInstant());
        }
        return newIndexingDate;
    }

    private boolean isFirstScanOfTheDay(LocalDate currentScanDate) {
        List pastScanDate = this.indexService.getAllScanDates();
        return !pastScanDate.isEmpty() && !((LocalDate)pastScanDate.get(0)).equals(currentScanDate);
    }
}

