/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.Bucket;
import io.dataintell.visionapi.domain.CloudCredentials;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.file.BulkProcessorFactory;
import io.dataintell.visionapi.file.IngestFileProcessor;
import io.dataintell.visionapi.s3Scanner.FileBuilderFromS3;
import io.dataintell.visionapi.s3Scanner.S3ClientBuilder;
import io.dataintell.visionapi.s3Scanner.ScanBucketHandler;
import io.dataintell.visionapi.service.BucketCredentialsService;
import io.dataintell.visionapi.service.BucketService;
import io.dataintell.visionapi.service.VolumeService;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;

@Service
public class ScanBucketService {
    private static final Logger log = LoggerFactory.getLogger(ScanBucketService.class);
    private final BucketService bucketService;
    private final BucketCredentialsService bucketCredentialsService;
    private final VolumeService volumeService;
    private final FileBuilderFromS3 fileBuilderFromS3;
    private final BulkProcessorFactory factory;

    public ScanBucketService(BucketService bucketService, BucketCredentialsService bucketCredentialsService, VolumeService volumeService, FileBuilderFromS3 fileBuilderFromS3, BulkProcessorFactory factory) {
        this.bucketService = bucketService;
        this.bucketCredentialsService = bucketCredentialsService;
        this.volumeService = volumeService;
        this.fileBuilderFromS3 = fileBuilderFromS3;
        this.factory = factory;
    }

    public void scanBucketsById(List<Integer> bucketsId, boolean isFirstScanOfTheDay) {
        log.info("About to scan buckets by id");
        this.scanBuckets(this.bucketService.getAllBucketsInIds(bucketsId), isFirstScanOfTheDay);
    }

    private void scanBuckets(List<Bucket> buckets, boolean isFirstScanOfTheDay) {
        LocalDate indexingDate = LocalDate.now();
        buckets.forEach(bucket -> this.scanBucket(indexingDate, bucket, isFirstScanOfTheDay));
    }

    private void scanBucket(LocalDate indexingDate, Bucket bucket, boolean isFirstScanOfTheDay) {
        long start = System.currentTimeMillis();
        CloudCredentials credentials = this.bucketCredentialsService.getWithKeys(bucket.getAwsCredentialsId().intValue());
        S3Client s3Client = new S3ClientBuilder(bucket, credentials).build();
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket.getBucketName()).encodingType(EncodingType.URL).build();
        ListObjectsV2Iterable pages = s3Client.listObjectsV2Paginator(request);
        long bucketSize = this.ingestBucketAndGetSize(indexingDate, bucket, pages, isFirstScanOfTheDay);
        long time = System.currentTimeMillis() - start;
        Volume volume = Volume.builder().id(bucket.getVolumeSettingId()).name(bucket.getDescription()).indexingDate(new Date()).crawlDuration(Long.valueOf(time)).free(Long.valueOf(0L)).used(Long.valueOf(bucketSize)).total(Long.valueOf(bucketSize)).type("AWS-S3").productName(bucket.getType().label).build();
        this.volumeService.saveVolume(volume);
        log.info("Scanning bucket id[{}], name[{}] took {} ms", new Object[]{bucket.getId(), bucket.getName(), time});
    }

    private long ingestBucketAndGetSize(LocalDate indexingDate, Bucket bucket, ListObjectsV2Iterable pages, boolean isFirstScanOfTheDay) {
        log.info("Scanning bucket id[{}], name[{}]", (Object)bucket.getId(), (Object)bucket.getName());
        IngestFileProcessor ingestFileProcessor = new IngestFileProcessor(this.factory.makeBulkProcessor(), indexingDate, isFirstScanOfTheDay);
        long bucketSize = 0L;
        File rootDirectory = this.fileBuilderFromS3.createBasicDirectoryFromS3(Path.of("/", new String[0]), null, bucket.getVolumeSettingId(), bucket.getDescription());
        ScanBucketHandler scanBucketHandler = new ScanBucketHandler(rootDirectory, ingestFileProcessor);
        for (ListObjectsV2Response page : pages) {
            bucketSize += page.contents().stream().mapToLong(S3Object::size).sum();
            for (S3Object s3Object : page.contents()) {
                if (this.isDirectory(s3Object)) {
                    File directory = this.fileBuilderFromS3.createDirectoryFromS3Object(s3Object, bucket.getDescription(), bucket.getVolumeSettingId());
                    scanBucketHandler.handleDirectory(directory);
                    continue;
                }
                File file = this.fileBuilderFromS3.createFileFromS3Object(s3Object, bucket.getDescription(), bucket.getVolumeSettingId());
                scanBucketHandler.handleFile(file);
            }
        }
        scanBucketHandler.handleRemainingDirectories();
        ingestFileProcessor.closeIngestProcessor();
        return bucketSize;
    }

    private boolean isDirectory(S3Object s3Object) {
        return s3Object.key().charAt(s3Object.key().length() - 1) == '/';
    }
}

