/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.Privilege;
import io.dataintell.visionapi.domain.Role;
import io.dataintell.visionapi.domain.RoleType;
import io.dataintell.visionapi.domain.User;
import io.dataintell.visionapi.entity.PrivilegeEntity;
import io.dataintell.visionapi.entity.RoleEntity;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.OperationForbiddenException;
import io.dataintell.visionapi.problem.SQLDeleteForeignKeyConstraintException;
import io.dataintell.visionapi.problem.UniqueConstraintException;
import io.dataintell.visionapi.repository.RoleRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleService.class);
    private final RoleRepository repository;

    public RoleService(RoleRepository repository) {
        this.repository = repository;
    }

    public Role create(Role role) {
        try {
            if (role.getPrivileges() == null) {
                role.setPrivileges(new ArrayList());
            }
            role.setType(RoleType.GROUP);
            return this.toDto((RoleEntity)this.repository.save((Object)this.toEntity(role)));
        }
        catch (DataIntegrityViolationException ex) {
            throw new UniqueConstraintException(Role.class, "name", role.getName());
        }
    }

    public PaginatedResult<Role> getAll(Integer page, Integer size, String sort, String direction) {
        Page roles = this.repository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)direction), (String[])new String[]{sort}))).map(arg_0 -> this.toDto(arg_0));
        return new PaginatedResult(roles, direction, sort, size);
    }

    public Role get(Long id) {
        return this.toDto((RoleEntity)this.repository.findById((Object)id).orElseThrow(this.notFound(id)));
    }

    public Role update(Long id, Role role) {
        try {
            RoleEntity roleEntity;
            if (role.getPrivileges() == null) {
                role.setPrivileges(new ArrayList());
            }
            if (this.isNotSystemRole((roleEntity = (RoleEntity)this.repository.findById((Object)id).orElseThrow(this.notFound(id))).getType())) {
                roleEntity.setName(role.getName());
                roleEntity.getPrivilegeEntities().clear();
                roleEntity.getPrivilegeEntities().addAll(this.getPrivilegeEntities(role.getPrivileges(), id));
                roleEntity.setDescription(role.getDescription());
                return this.toDto((RoleEntity)this.repository.save((Object)roleEntity));
            }
            throw new OperationForbiddenException(String.format("Cannot modify SYSTEM role id[%s], name[%s]", id, roleEntity.getName()));
        }
        catch (DataIntegrityViolationException ex) {
            throw new UniqueConstraintException(Role.class, "name", role.getName());
        }
    }

    public void delete(Long id) {
        RoleEntity role = (RoleEntity)this.repository.findById((Object)id).orElseThrow(this.notFound(id));
        try {
            if (!this.isNotSystemRole(role.getType())) {
                throw new OperationForbiddenException(String.format("Cannot delete SYSTEM role id[%s], name[%s]", id, role.getName()));
            }
            this.repository.deleteById((Object)id);
        }
        catch (DataIntegrityViolationException e) {
            throw new SQLDeleteForeignKeyConstraintException(Role.class, String.valueOf(id), User.class);
        }
    }

    private boolean isNotSystemRole(String roleType) {
        return !RoleType.SYSTEM.name().equals(roleType);
    }

    private Role toDto(RoleEntity entity) {
        List privileges = entity.getPrivilegeEntities().stream().map(p -> Privilege.builder().id(p.getId()).resourceType(p.getResourceType()).resourceId(p.getResourceId()).action(p.getAction()).build()).collect(Collectors.toList());
        return Role.builder().id(entity.getId()).name(entity.getName()).privileges(privileges).type(RoleType.valueOf((String)entity.getType())).description(entity.getDescription()).build();
    }

    private RoleEntity toEntity(Role role) {
        return RoleEntity.builder().name(role.getName()).description(role.getDescription()).type(role.getType().name()).privilegeEntities(this.getPrivilegeEntities(role.getPrivileges(), role.getId())).build();
    }

    private Set<PrivilegeEntity> getPrivilegeEntities(List<Privilege> privileges, Long id) {
        return privileges.stream().map(p -> PrivilegeEntity.builder().id(p.getId()).action(p.getAction()).resourceType(p.getResourceType()).resourceId(p.getResourceId()).roleId(id).build()).collect(Collectors.toSet());
    }

    private Supplier<EntityNotFoundException> notFound(Long id) {
        return () -> new EntityNotFoundException(RoleEntity.class, String.valueOf(id));
    }
}

