/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.BasicStatistic;
import io.dataintell.visionapi.domain.DetailedProject;
import io.dataintell.visionapi.domain.DetailedProjectPath;
import io.dataintell.visionapi.domain.ExcelValue;
import io.dataintell.visionapi.domain.FolderGroup;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.PeriodType;
import io.dataintell.visionapi.domain.StatisticType;
import io.dataintell.visionapi.domain.VariationGeneric;
import io.dataintell.visionapi.entity.Project;
import io.dataintell.visionapi.entity.ProjectPath;
import io.dataintell.visionapi.entity.StoragePriceEntity;
import io.dataintell.visionapi.entity.VolumeSetting;
import io.dataintell.visionapi.file.FileService;
import io.dataintell.visionapi.mapper.ProjectMapper;
import io.dataintell.visionapi.permission.ResourceType;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.PrivilegeRepository;
import io.dataintell.visionapi.repository.ProjectRepository;
import io.dataintell.visionapi.repository.VolumeSettingRepository;
import io.dataintell.visionapi.repository.elasticsearch.DetailedProjectRepository;
import io.dataintell.visionapi.repository.elasticsearch.FileRepository;
import io.dataintell.visionapi.schedule.ScheduleService;
import io.dataintell.visionapi.schedule.job.SendProjectSpaceAlertJob;
import io.dataintell.visionapi.service.ExcelService;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.utils.DateUtils;
import io.dataintell.visionapi.utils.PricingUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import javassist.NotFoundException;
import org.apache.commons.io.FileUtils;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectService {
    private static final Logger log = LoggerFactory.getLogger(ProjectService.class);
    private static final String RESOURCEIDS = "resourceIds";
    private final ProjectRepository projectRepository;
    private final FileRepository fileRepository;
    private final VolumeSettingRepository volumeSettingRepository;
    private final DetailedProjectRepository detailedProjectRepository;
    private final IndexService indexService;
    private final ProjectMapper projectMapper;
    private final ExcelService excelService;
    private final FileService fileService;
    private final ScheduleService scheduleService;
    private final PrivilegeRepository privilegeRepository;

    public ProjectService(ProjectRepository projectRepository, FileRepository fileRepository, VolumeSettingRepository volumeSettingRepository, DetailedProjectRepository detailedProjectRepository, IndexService indexService, ProjectMapper projectMapper, ExcelService excelService, FileService fileService, ScheduleService scheduleService, PrivilegeRepository privilegeRepository) {
        this.projectRepository = projectRepository;
        this.fileRepository = fileRepository;
        this.volumeSettingRepository = volumeSettingRepository;
        this.detailedProjectRepository = detailedProjectRepository;
        this.indexService = indexService;
        this.projectMapper = projectMapper;
        this.excelService = excelService;
        this.fileService = fileService;
        this.scheduleService = scheduleService;
        this.privilegeRepository = privilegeRepository;
    }

    public PaginatedResult<DetailedProject> getDetailedProjects(Integer page, Integer size, String sort, String direction, LocalDate indexingDate, String filter) throws IOException {
        log.debug("About to get detailed projects on page [{}] and with size [{}]", (Object)page, (Object)size);
        Integer from = (page - 1) * size;
        SearchResponse searchResponse = this.detailedProjectRepository.findAll(from, size, sort, SortOrder.fromString((String)direction), indexingDate, filter);
        return this.projectMapper.getPaginatedResultWithSize(page.intValue(), size.intValue(), sort, direction, searchResponse);
    }

    public DetailedProject getDetailedProjectById(long id, LocalDate indexingDate) {
        log.debug("About to get detailed project with id [{}]", (Object)id);
        GetResponse response = (GetResponse)this.detailedProjectRepository.findOne(Long.valueOf(id), indexingDate).orElseThrow(this.notFound(Long.valueOf(id)));
        return this.projectMapper.getGsonFromJson(response);
    }

    public List<DetailedProject> getDetailedProjectHistoryById(Long id, Integer size, LocalDate indexingDate) {
        try {
            return this.projectMapper.convertToDto(this.detailedProjectRepository.findProjectHistoryById(id, size, indexingDate));
        }
        catch (IOException e) {
            log.error("An error occurred while fetching the history of the detailed project with id [{}] and indexing date [{}]", (Object)id, (Object)indexingDate);
            return new ArrayList<DetailedProject>();
        }
    }

    public Project getProjectById(Long id) {
        log.debug("About to get project for id [{}]", (Object)id);
        return (Project)this.projectRepository.findById((Object)id).orElseThrow(this.notFound(id));
    }

    public PaginatedResult<Project> getAll(Integer page, Integer size, String sort, String direction) {
        log.info("About to get all projects");
        Page projects = this.projectRepository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)direction), (String[])new String[]{sort})));
        return new PaginatedResult(projects, direction, sort, size);
    }

    public Project createProject(Project project) {
        log.info("About to create project with name [{}]", (Object)project.getName());
        Project createdProject = (Project)this.projectRepository.save((Object)project);
        this.indexProject(createdProject);
        return createdProject;
    }

    public Project updateProject(Project project) {
        log.info("About to update project with id [{}]", (Object)project.getId());
        this.projectRepository.findById((Object)project.getId()).orElseThrow(this.notFound(project.getId()));
        Project updatedProject = (Project)this.projectRepository.save((Object)project);
        this.indexProject(updatedProject);
        return updatedProject;
    }

    @Transactional
    public void deleteProject(Long id, LocalDate indexingDate) {
        log.info("About to delete project with id [{}]", (Object)id);
        this.projectRepository.deleteById((Object)id);
        this.removeProjectIdFromJobs(id.intValue());
        this.privilegeRepository.deletePrivilegeEntitiesByResourceIdAndResourceType(id, ResourceType.PROJECT);
        try {
            this.detailedProjectRepository.deleteOne(id, indexingDate);
        }
        catch (IOException e) {
            log.error("An error occurred while trying to delete detailedProject from ES");
        }
    }

    public void indexAllProjects(LocalDate indexingDate) {
        log.info("About to index all projects for indexingDate");
        this.indexProjects(0, 10, indexingDate);
    }

    public File getReportForProject(Long id, LocalDate indexingDate) throws IOException, NotFoundException {
        DetailedProject detailedProject = this.getDetailedProjectById(id.longValue(), indexingDate);
        List folderGroups = detailedProject.getFolderGroups();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        StoragePriceEntity projectStoragePriceEntity = folderGroups.size() == 0 ? null : this.getVolumeSettingById(Long.valueOf(((FolderGroup)folderGroups.get(0)).getVolumeId())).getStoragePrice();
        ArrayList<ExcelValue> excelValues = new ArrayList<ExcelValue>();
        excelValues.add(new ExcelValue(Integer.valueOf(3), Integer.valueOf(0), detailedProject.getName(), Boolean.valueOf(false)));
        Double usedSpace = (double)detailedProject.getSize().longValue() / (double)detailedProject.getAllocatedSize().longValue();
        excelValues.add(new ExcelValue(Integer.valueOf(5), Integer.valueOf(1), String.format("%.4f", usedSpace), Boolean.valueOf(false)));
        excelValues.add(new ExcelValue(Integer.valueOf(6), Integer.valueOf(1), FileUtils.byteCountToDisplaySize((long)detailedProject.getSize()), Boolean.valueOf(false)));
        excelValues.add(new ExcelValue(Integer.valueOf(8), Integer.valueOf(1), FileUtils.byteCountToDisplaySize((long)detailedProject.getAllocatedSize()), Boolean.valueOf(false)));
        excelValues.add(new ExcelValue(Integer.valueOf(9), Integer.valueOf(1), detailedProject.getNumberOfFiles().toString(), Boolean.valueOf(false)));
        if (detailedProject.getLastAccessDate() != null) {
            excelValues.add(new ExcelValue(Integer.valueOf(10), Integer.valueOf(1), dateFormat.format(detailedProject.getLastAccessDate()), Boolean.valueOf(false)));
        } else {
            excelValues.add(new ExcelValue(Integer.valueOf(10), Integer.valueOf(1), "N/A", Boolean.valueOf(false)));
        }
        if (detailedProject.getLastModifiedDate() != null) {
            excelValues.add(new ExcelValue(Integer.valueOf(11), Integer.valueOf(1), dateFormat.format(detailedProject.getLastModifiedDate()), Boolean.valueOf(false)));
        } else {
            excelValues.add(new ExcelValue(Integer.valueOf(11), Integer.valueOf(1), "N/A", Boolean.valueOf(false)));
        }
        long spaceLeft = detailedProject.getAllocatedSize() - detailedProject.getSize();
        if (spaceLeft < 0L) {
            spaceLeft = 0L;
        }
        excelValues.add(new ExcelValue(Integer.valueOf(5), Integer.valueOf(3), String.format("Space left (%s)", FileUtils.byteCountToDisplaySize((long)spaceLeft)), Boolean.valueOf(false)));
        excelValues.add(new ExcelValue(Integer.valueOf(6), Integer.valueOf(3), String.format("Actual space (%s)", FileUtils.byteCountToDisplaySize((long)detailedProject.getSize())), Boolean.valueOf(false)));
        excelValues.add(new ExcelValue(Integer.valueOf(5), Integer.valueOf(4), Long.toString(spaceLeft), Boolean.valueOf(false)));
        excelValues.add(new ExcelValue(Integer.valueOf(6), Integer.valueOf(4), detailedProject.getSize().toString(), Boolean.valueOf(false)));
        int cpt = 0;
        BigDecimal totalMonthlyCost = BigDecimal.ZERO;
        for (FolderGroup folderGroup : folderGroups) {
            StoragePriceEntity folderGroupStoragePrice = this.getVolumeSettingById(Long.valueOf(folderGroup.getVolumeId())).getStoragePrice();
            BigDecimal folderGroupMonthlyCostPrice = folderGroupStoragePrice == null ? BigDecimal.ZERO : PricingUtils.getMonthlyCost((BigDecimal)folderGroupStoragePrice.getPrice(), (Long)folderGroup.getSizeInBytes());
            String folderGroupMonthlyCostCurrencySymbol = folderGroupStoragePrice == null ? "$" : folderGroupStoragePrice.getCurrencySymbol();
            String folderGroupType = this.getVolumeSettingById(Long.valueOf(folderGroup.getVolumeId())).getType();
            totalMonthlyCost = totalMonthlyCost.add(folderGroupMonthlyCostPrice);
            excelValues.add(new ExcelValue(Integer.valueOf(17 + cpt), Integer.valueOf(0), "Volume name", Boolean.valueOf(false)));
            excelValues.add(new ExcelValue(Integer.valueOf(17 + cpt), Integer.valueOf(1), folderGroup.getName(), Boolean.valueOf(true)));
            excelValues.add(new ExcelValue(Integer.valueOf(18 + cpt), Integer.valueOf(0), "Size", Boolean.valueOf(false)));
            excelValues.add(new ExcelValue(Integer.valueOf(18 + cpt), Integer.valueOf(1), FileUtils.byteCountToDisplaySize((long)folderGroup.getSizeInBytes()), Boolean.valueOf(true)));
            excelValues.add(new ExcelValue(Integer.valueOf(19 + cpt), Integer.valueOf(0), "Monthly cost", Boolean.valueOf(false)));
            excelValues.add(new ExcelValue(Integer.valueOf(19 + cpt), Integer.valueOf(1), String.format("%s%s", folderGroupMonthlyCostPrice, folderGroupMonthlyCostCurrencySymbol), Boolean.valueOf(true)));
            excelValues.add(new ExcelValue(Integer.valueOf(20 + cpt), Integer.valueOf(0), "Duplicate data", Boolean.valueOf(false)));
            excelValues.add(new ExcelValue(Integer.valueOf(20 + cpt), Integer.valueOf(1), FileUtils.byteCountToDisplaySize((long)folderGroup.getDuplicateFilesSizeInBytes()), Boolean.valueOf(true)));
            if (folderGroupType.equals("crawl.files")) {
                excelValues.addAll(this.addLastAccessStatisticsToReport(folderGroup, cpt));
            } else {
                excelValues.addAll(this.addLastModifiedStatisticsToReport(folderGroup, cpt));
            }
            cpt += 6;
        }
        excelValues.add(new ExcelValue(Integer.valueOf(7), Integer.valueOf(1), String.format("%s%s", totalMonthlyCost, projectStoragePriceEntity == null ? "$" : projectStoragePriceEntity.getCurrencySymbol()), Boolean.valueOf(false)));
        return this.excelService.fillTemplateWithData("projectReportv2", excelValues);
    }

    private List<ExcelValue> addLastAccessStatisticsToReport(FolderGroup folderGroup, int cpt) {
        ArrayList<ExcelValue> lastAccessValues = new ArrayList<ExcelValue>();
        lastAccessValues.add(new ExcelValue(Integer.valueOf(17 + cpt), Integer.valueOf(3), "Last access date > 1 year", Boolean.valueOf(false)));
        lastAccessValues.add(new ExcelValue(Integer.valueOf(17 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnusedFilesOneYearSizeInBytes()), Boolean.valueOf(true)));
        lastAccessValues.add(new ExcelValue(Integer.valueOf(18 + cpt), Integer.valueOf(3), "Last access date > 6 months", Boolean.valueOf(false)));
        lastAccessValues.add(new ExcelValue(Integer.valueOf(18 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnusedFilesSixMonthsSizeInBytes()), Boolean.valueOf(true)));
        lastAccessValues.add(new ExcelValue(Integer.valueOf(19 + cpt), Integer.valueOf(3), "Last access date > 3 months", Boolean.valueOf(false)));
        lastAccessValues.add(new ExcelValue(Integer.valueOf(19 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnusedFilesThreeMonthsSizeInBytes()), Boolean.valueOf(true)));
        lastAccessValues.add(new ExcelValue(Integer.valueOf(20 + cpt), Integer.valueOf(3), "Last access date > 1 month", Boolean.valueOf(false)));
        lastAccessValues.add(new ExcelValue(Integer.valueOf(20 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnusedFilesOneMonthSizeInBytes()), Boolean.valueOf(true)));
        return lastAccessValues;
    }

    private List<ExcelValue> addLastModifiedStatisticsToReport(FolderGroup folderGroup, int cpt) {
        ArrayList<ExcelValue> lastModifiedValues = new ArrayList<ExcelValue>();
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(17 + cpt), Integer.valueOf(3), "Last modified date > 1 year", Boolean.valueOf(false)));
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(17 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnmodifiedFilesOneYearSizeInBytes()), Boolean.valueOf(true)));
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(18 + cpt), Integer.valueOf(3), "Last modified date > 6 months", Boolean.valueOf(false)));
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(18 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnmodifiedFilesSixMonthsSizeInBytes()), Boolean.valueOf(true)));
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(19 + cpt), Integer.valueOf(3), "Last modified date > 3 months", Boolean.valueOf(false)));
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(19 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnmodifiedFilesThreeMonthsSizeInBytes()), Boolean.valueOf(true)));
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(20 + cpt), Integer.valueOf(3), "Last modified date > 1 month", Boolean.valueOf(false)));
        lastModifiedValues.add(new ExcelValue(Integer.valueOf(20 + cpt), Integer.valueOf(4), FileUtils.byteCountToDisplaySize((long)folderGroup.getUnmodifiedFilesOneMonthSizeInBytes()), Boolean.valueOf(true)));
        return lastModifiedValues;
    }

    private void indexProjects(int page, int size, LocalDate indexingDate) {
        log.info("About to index projects on page [{}] and with size [{}]", (Object)page, (Object)size);
        Page projects = this.projectRepository.findAll((Pageable)PageRequest.of((int)page, (int)size));
        projects.getContent().forEach(project -> this.indexProject(indexingDate, project));
        if (projects.hasNext()) {
            this.indexProjects(page + 1, size, indexingDate);
        }
    }

    private void indexProject(LocalDate indexingDate, Project project) {
        try {
            DetailedProject detailedProject = this.createDetailedProject(project, indexingDate);
            this.detailedProjectRepository.indexDetailedProject(detailedProject, indexingDate);
        }
        catch (IOException e) {
            log.error("Unable to index project id [{}]", (Object)project.getId(), (Object)e);
        }
    }

    private void indexProject(Project project) {
        this.indexService.getAllScanDates().forEach(date -> {
            try {
                DetailedProject detailedProject = this.createDetailedProject(project, date);
                this.detailedProjectRepository.indexDetailedProject(detailedProject, date);
            }
            catch (IOException e) {
                log.error("Unable to index project id [{}]", (Object)project.getId(), (Object)e);
            }
        });
    }

    private DetailedProject createDetailedProject(Project projectEntity, LocalDate indexingDate) throws IOException {
        DetailedProject detailedProject = new DetailedProject();
        detailedProject.setId(projectEntity.getId());
        detailedProject.setDescription(projectEntity.getDescription());
        detailedProject.setName(projectEntity.getName());
        detailedProject.setIndexingDate(this.getIndexingDate(indexingDate));
        detailedProject.setAllocatedSize(projectEntity.getAllocatedSize());
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<Long> volumeList = new ArrayList<Long>();
        ArrayList<DetailedProjectPath> detailedProjectPaths = new ArrayList<DetailedProjectPath>();
        for (ProjectPath projectPath : projectEntity.getPaths()) {
            pathList.add(projectPath.getPath());
            volumeList.add(projectPath.getVolumeSetting().getId());
            detailedProjectPaths.add(this.getDetailedProjectPath(indexingDate, projectPath));
        }
        detailedProject.setDetailedProjectPaths(detailedProjectPaths);
        SearchResponse response = this.fileRepository.getFilesOfDirectories(pathList, volumeList, Boolean.valueOf(false), Boolean.valueOf(false), null, Integer.valueOf(0), Integer.valueOf(0), "size", SortOrder.DESC, Boolean.valueOf(true), indexingDate);
        detailedProject.setNumberOfFiles(Long.valueOf(response.getHits().getTotalHits().value));
        if (detailedProject.getNumberOfFiles() > 0L) {
            Aggregations aggregations = response.getAggregations();
            Max lastAccessAll = (Max)aggregations.get("lastAccess");
            if (lastAccessAll.getValue() >= 0.0) {
                detailedProject.setLastAccessDate(new Date((long)lastAccessAll.getValue()));
            }
            Max lastModifiedAll = (Max)aggregations.get("lastModified");
            detailedProject.setLastModifiedDate(new Date((long)lastModifiedAll.getValue()));
            detailedProject.setSize(this.getSize(response));
        } else {
            detailedProject.setSize(Long.valueOf(0L));
        }
        return detailedProject;
    }

    private DetailedProjectPath getDetailedProjectPath(LocalDate indexingDate, ProjectPath projectPath) throws IOException {
        DetailedProjectPath detailedProjectPath = new DetailedProjectPath();
        detailedProjectPath.setId(projectPath.getId());
        detailedProjectPath.setPath(projectPath.getPath());
        detailedProjectPath.setVolumeId(projectPath.getVolumeSetting().getId());
        detailedProjectPath.setVolumeName(this.getVolumeNameOfProjectPath(projectPath));
        VolumeSetting volumeSetting = this.getVolumeSettingById(projectPath.getVolumeSetting().getId());
        HashMap<StatisticType, BasicStatistic> pathStatistics = new HashMap<StatisticType, BasicStatistic>();
        SearchResponse response = this.fileRepository.getFilesOfDirectories(Collections.singletonList(projectPath.getPath()), Collections.singletonList(projectPath.getVolumeSetting().getId()), Boolean.valueOf(false), Boolean.valueOf(false), null, Integer.valueOf(0), Integer.valueOf(0), "size", SortOrder.DESC, Boolean.valueOf(true), indexingDate);
        detailedProjectPath.setNumberOfFiles(Long.valueOf(response.getHits().getTotalHits().value));
        if (detailedProjectPath.getNumberOfFiles() > 0L) {
            Aggregations aggregations = response.getAggregations();
            Max lastAccessAll = (Max)aggregations.get("lastAccess");
            detailedProjectPath.setLastAccessDate(new Date((long)lastAccessAll.getValue()));
            Max lastModifiedAll = (Max)aggregations.get("lastModified");
            detailedProjectPath.setLastModifiedDate(new Date((long)lastModifiedAll.getValue()));
            detailedProjectPath.setSize(this.getSize(response));
            pathStatistics.put(StatisticType.DUPLICATE, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), null, null, indexingDate, Boolean.valueOf(true)));
            if (volumeSetting.getType().equals("AWS-S3") || volumeSetting.getType().equals("Archiware")) {
                detailedProjectPath.setLastAccessDate(null);
                this.setPathStatisticsForBucketAndArchiware(indexingDate, projectPath, pathStatistics);
            } else {
                this.setPathStatisticsForVolume(indexingDate, projectPath, pathStatistics);
            }
        } else {
            detailedProjectPath.setSize(Long.valueOf(0L));
        }
        detailedProjectPath.setStatistics(pathStatistics);
        return detailedProjectPath;
    }

    private String getVolumeNameOfProjectPath(ProjectPath projectPath) {
        if (projectPath.getVolumeSetting().getName().contains("S3-BUCKET-")) {
            return projectPath.getVolumeSetting().getName().substring(10);
        }
        return projectPath.getVolumeSetting().getName();
    }

    private void setPathStatisticsForVolume(LocalDate indexingDate, ProjectPath projectPath, HashMap<StatisticType, BasicStatistic> pathStatistics) {
        pathStatistics.put(StatisticType.LAST_ACCESS_ONE_WEEK, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), LocalDate.now().minusWeeks(1L), null, indexingDate, null));
        pathStatistics.put(StatisticType.LAST_ACCESS_ONE_MONTH, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), LocalDate.now().minusMonths(1L), null, indexingDate, null));
        pathStatistics.put(StatisticType.LAST_ACCESS_THREE_MONTH, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), LocalDate.now().minusMonths(3L), null, indexingDate, null));
        pathStatistics.put(StatisticType.LAST_ACCESS_SIX_MONTH, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), LocalDate.now().minusMonths(6L), null, indexingDate, null));
        pathStatistics.put(StatisticType.LAST_ACCESS_ONE_YEAR, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), LocalDate.now().minusYears(1L), null, indexingDate, null));
    }

    private void setPathStatisticsForBucketAndArchiware(LocalDate indexingDate, ProjectPath projectPath, HashMap<StatisticType, BasicStatistic> pathStatistics) {
        pathStatistics.put(StatisticType.LAST_MODIFIED_ONE_WEEK, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), null, LocalDate.now().minusWeeks(1L), indexingDate, null));
        pathStatistics.put(StatisticType.LAST_MODIFIED_ONE_MONTH, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), null, LocalDate.now().minusMonths(1L), indexingDate, null));
        pathStatistics.put(StatisticType.LAST_MODIFIED_THREE_MONTH, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), null, LocalDate.now().minusMonths(3L), indexingDate, null));
        pathStatistics.put(StatisticType.LAST_MODIFIED_SIX_MONTH, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), null, LocalDate.now().minusMonths(6L), indexingDate, null));
        pathStatistics.put(StatisticType.LAST_MODIFIED_ONE_YEAR, this.getBasicStatistic(projectPath.getVolumeSetting().getId(), projectPath.getPath(), null, LocalDate.now().minusYears(1L), indexingDate, null));
    }

    private BasicStatistic getBasicStatistic(Long volumeId, String path, LocalDate lastAccessBefore, LocalDate lastModifiedBefore, LocalDate indexingDate, Boolean isDuplicate) {
        Long numberOfFiles = this.fileService.searchFiles("", isDuplicate, Collections.singletonList(volumeId), path, null, null, null, lastAccessBefore, null, lastModifiedBefore, null, null, null, Integer.valueOf(1), Integer.valueOf(0), "size", null, null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, indexingDate).getTotal();
        Long size = this.fileService.getSizeOfSearchedFiles("", isDuplicate, Collections.singletonList(volumeId), path, null, null, null, lastAccessBefore, null, lastModifiedBefore, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, indexingDate);
        BasicStatistic basicStatistic = new BasicStatistic();
        basicStatistic.setNumberOfFiles(numberOfFiles);
        basicStatistic.setSize(size);
        return basicStatistic;
    }

    private Long getSize(SearchResponse response) {
        Aggregations aggregations = response.getAggregations();
        Sum agg = (Sum)aggregations.get("size");
        return (long)agg.getValue();
    }

    public List<VariationGeneric<DetailedProject, Long>> getMostActiveProject(LocalDate indexingDate, Integer size, PeriodType type, Integer duration) throws IOException {
        PaginatedResult count = this.getDetailedProjects(Integer.valueOf(1), Integer.valueOf(0), "name", "asc", indexingDate, "");
        Integer numberOfElements = count.getTotal().intValue();
        PaginatedResult projectPaginatedResult = this.getDetailedProjects(Integer.valueOf(1), numberOfElements, "name", "asc", indexingDate, "");
        List crawlDates = this.indexService.getAllScanDates();
        LocalDate previousIndexingDate = DateUtils.getPreviousLocalDate((LocalDate)indexingDate, (Boolean)true, (PeriodType)type, (Integer)duration);
        PaginatedResult projectPaginatedResultPreviousDate = this.getProjectPaginatedResultPreviousDate(crawlDates, previousIndexingDate);
        return this.getListMostSizeVariation(projectPaginatedResult.getElements(), projectPaginatedResultPreviousDate.getElements(), size, indexingDate);
    }

    private PaginatedResult<DetailedProject> getProjectPaginatedResultPreviousDate(List<LocalDate> crawlDates, LocalDate previousIndexingDate) throws IOException {
        PaginatedResult projectPaginatedResultDaysBefore;
        if (crawlDates.contains(previousIndexingDate)) {
            PaginatedResult count = this.getDetailedProjects(Integer.valueOf(1), Integer.valueOf(0), "name", "asc", previousIndexingDate, "");
            int numberOfElements = count.getTotal().intValue();
            projectPaginatedResultDaysBefore = this.getDetailedProjects(Integer.valueOf(1), Integer.valueOf(numberOfElements), "name", "asc", previousIndexingDate, "");
        } else {
            TreeSet<LocalDate> ts = new TreeSet<LocalDate>(crawlDates);
            LocalDate closestIndexingDate = null;
            if (ts.ceiling(previousIndexingDate) != null) {
                closestIndexingDate = ts.ceiling(previousIndexingDate);
            } else if (ts.floor(previousIndexingDate) != null) {
                closestIndexingDate = ts.floor(previousIndexingDate);
            }
            PaginatedResult count = this.getDetailedProjects(Integer.valueOf(1), Integer.valueOf(0), "name", "asc", closestIndexingDate, "");
            int numberOfElements = count.getTotal().intValue();
            projectPaginatedResultDaysBefore = this.getDetailedProjects(Integer.valueOf(1), Integer.valueOf(numberOfElements), "name", "asc", closestIndexingDate, "");
        }
        return projectPaginatedResultDaysBefore;
    }

    private List<VariationGeneric<DetailedProject, Long>> getListMostSizeVariation(List<DetailedProject> list1, List<DetailedProject> list2, Integer numberOfMostActiveProjects, LocalDate indexingDate) {
        List intersectionList = this.getIntersectionList(list1, list2, indexingDate);
        ArrayList<VariationGeneric<DetailedProject, Long>> mostSizeVariation = new ArrayList<VariationGeneric<DetailedProject, Long>>();
        int maximumSize = intersectionList.size() < numberOfMostActiveProjects ? intersectionList.size() : numberOfMostActiveProjects.intValue();
        for (int i = 0; i < maximumSize; ++i) {
            VariationGeneric variationGeneric = (VariationGeneric)intersectionList.get(i);
            mostSizeVariation.add((VariationGeneric<DetailedProject, Long>)variationGeneric);
        }
        return mostSizeVariation;
    }

    private List<VariationGeneric<DetailedProject, Long>> getIntersectionList(List<DetailedProject> list1, List<DetailedProject> list2, LocalDate indexingDate) {
        ArrayList<VariationGeneric<DetailedProject, Long>> intersectionList = new ArrayList<VariationGeneric<DetailedProject, Long>>();
        for (DetailedProject dp1 : list1) {
            for (DetailedProject dp2 : list2) {
                if (!dp1.getId().equals(dp2.getId())) continue;
                Long variation = dp1.getSize() - dp2.getSize();
                LocalDate localDate1 = dp1.getIndexingDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate localDate2 = dp2.getIndexingDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                long intervalNumberOfDays = ChronoUnit.DAYS.between(localDate2, localDate1);
                VariationGeneric variationGeneric = new VariationGeneric((Object)variation, "size", (Object)dp1, (Object)dp2, indexingDate, Integer.valueOf((int)intervalNumberOfDays));
                if (intersectionList.contains(variationGeneric)) continue;
                intersectionList.add((VariationGeneric<DetailedProject, Long>)variationGeneric);
            }
        }
        Comparator<VariationGeneric> detailedProjectComparator = Comparator.comparing(VariationGeneric::getVariation, Comparator.reverseOrder());
        intersectionList.sort(detailedProjectComparator);
        return intersectionList;
    }

    private Date getIndexingDate(LocalDate indexingDate) {
        Date newIndexingDate = new Date();
        LocalDate scanDateFormatted = newIndexingDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (!scanDateFormatted.equals(indexingDate)) {
            newIndexingDate = Date.from(indexingDate.atTime(LocalTime.MAX).atZone(ZoneId.systemDefault()).toInstant());
        }
        return newIndexingDate;
    }

    private void removeProjectIdFromJobs(int id) {
        List schedules = this.scheduleService.getAllByJobClass(SendProjectSpaceAlertJob.class.getName());
        schedules.forEach(schedule -> {
            List ids = (List)schedule.getPayload().get(RESOURCEIDS);
            if (ids.contains(id)) {
                if (ids.size() == 1) {
                    this.scheduleService.delete(schedule.getId().longValue());
                } else {
                    ids.remove((Object)id);
                    schedule.getPayload().replace(RESOURCEIDS, ids);
                    this.scheduleService.update(schedule.getId().longValue(), schedule);
                }
            }
        });
    }

    private VolumeSetting getVolumeSettingById(Long id) {
        Optional volumeSetting = this.volumeSettingRepository.findById((Object)id);
        if (volumeSetting.isPresent()) {
            return (VolumeSetting)volumeSetting.get();
        }
        throw new EntityNotFoundException(VolumeSetting.class, String.valueOf(id));
    }

    private Supplier<EntityNotFoundException> notFound(Long id) {
        return () -> new EntityNotFoundException(Project.class, String.valueOf(id));
    }
}

