/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogService.class);

    public ByteArrayResource getLogs() throws IOException {
        String dirPath = String.format("/tmp/logs-%s", new Date().getTime());
        File logDir = new File(dirPath);
        if (!logDir.mkdir()) {
            throw new IOException(String.format("Unable to create temporary directory [%s] on the server", dirPath));
        }
        this.copyFilesWithPattern(dirPath, "/var/log/dataintell*");
        this.copyFilesWithPattern(dirPath, "/var/log/elasticsearch/dataintell*");
        this.copyFilesWithPattern(dirPath, "/var/log/elasticsearch/elasticsearch*");
        String zipFileName = logDir.getAbsolutePath().concat(".zip");
        this.compressDirectory(dirPath, zipFileName);
        Path zipPath = Paths.get(zipFileName, new String[0]);
        return new ByteArrayResource(Files.readAllBytes(zipPath));
    }

    private void copyFilesWithPattern(String dest, String pattern) {
        String[] filePaths;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(new String[]{pattern});
        scanner.setCaseSensitive(false);
        scanner.scan();
        for (String filePath : filePaths = scanner.getIncludedFiles()) {
            Path originalPath = Paths.get(filePath, new String[0]);
            Path newPath = Paths.get(dest, originalPath.getFileName().toString());
            try {
                Files.copy(originalPath, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error("Failure copying files", (Throwable)e);
            }
        }
    }

    private void compressDirectory(String dir, String zipFile) {
        File directory = new File(dir);
        List fileList = this.getFileList(directory);
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (String filePath : fileList) {
                LOGGER.info("Compressing: {}", (Object)filePath);
                String name = filePath.substring(directory.getAbsolutePath().length() + 1);
                ZipEntry zipEntry = new ZipEntry(name);
                zos.putNextEntry(zipEntry);
                try (FileInputStream fis = new FileInputStream(filePath);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failure compressing directory", (Throwable)e);
        }
    }

    private List<String> getFileList(File directory) {
        ArrayList<String> fileList = new ArrayList<String>();
        File[] files = directory.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isFile()) {
                    fileList.add(file.getAbsolutePath());
                    continue;
                }
                this.getFileList(file);
            }
        }
        return fileList;
    }
}

