/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.Configuration;
import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.entity.ConfigurationEntity;
import io.dataintell.visionapi.problem.ElasticsearchIOException;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.ConfigurationRepository;
import io.dataintell.visionapi.repository.elasticsearch.IndexRepository;
import io.dataintell.visionapi.utils.ESFileQueryUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.elasticsearch.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IndexService {
    private static final Logger log = LoggerFactory.getLogger(IndexService.class);
    public static final String SNAPSHOT_NUMBER_OF_DAYS = "snapshot.numberOfDays";
    public static final String SNAPSHOT_KEEP_FIRST_DAY_OF_MONTH = "snapshot.keepFirstDayOfMonth";
    private final IndexRepository indexRepository;
    private final ConfigurationRepository configurationRepository;

    public IndexService(IndexRepository indexRepository, ConfigurationRepository configurationRepository) {
        this.indexRepository = indexRepository;
        this.configurationRepository = configurationRepository;
    }

    public void deleteIndexBasedOnConfigurations() {
        List indexList;
        log.info("About to delete index based on configuration");
        ConfigurationEntity numberOfDays = (ConfigurationEntity)this.configurationRepository.findOneByName(SNAPSHOT_NUMBER_OF_DAYS).orElseThrow(this.notFound());
        ConfigurationEntity firstDayOfMonth = (ConfigurationEntity)this.configurationRepository.findOneByName(SNAPSHOT_KEEP_FIRST_DAY_OF_MONTH).orElseThrow(this.notFound());
        try {
            indexList = this.indexRepository.getIndices();
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
        List indexDates = this.getLocalDatesOfIndex(indexList).stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
        LocalDate firstDayToKeep = LocalDate.now().minusDays(Integer.parseInt(numberOfDays.getValue()));
        boolean keepFistDayOfMonth = firstDayOfMonth != null && firstDayOfMonth.getValue().equals("true");
        boolean isFirstInList = true;
        for (LocalDate date : indexDates) {
            if (isFirstInList) {
                isFirstInList = false;
                continue;
            }
            if (!firstDayToKeep.isAfter(date) || keepFistDayOfMonth && date.getDayOfMonth() == 1) continue;
            try {
                this.indexRepository.deleteFileIndex(date);
            }
            catch (IOException e) {
                log.error(String.format("There was an error while deleting some index data for date [%s]", date), (Throwable)e);
            }
        }
    }

    private Supplier<EntityNotFoundException> notFound() {
        return () -> new EntityNotFoundException(Configuration.class, "Configuration for deleting snapshot is missing or invalid");
    }

    public List<LocalDate> getAllScanDates() {
        log.debug("About to get all dates from all the scans");
        try {
            return this.indexRepository.getIndices().stream().filter(i -> i.startsWith("file-")).map(index -> LocalDate.parse(index.replace("file-", ""))).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public Optional<LocalDate> getMostRecentScanDate() {
        List scanDates = this.getAllScanDates();
        if (scanDates.size() == 0) {
            return Optional.empty();
        }
        return Optional.of((LocalDate)scanDates.get(0));
    }

    public void createFileIndex(LocalDate indexingDate, boolean cloneIndex) throws IOException, NotFoundException, InterruptedException {
        List scanDates = this.getAllScanDates();
        if (cloneIndex && scanDates.size() > 0 && !((LocalDate)scanDates.get(0)).equals(LocalDate.now())) {
            String todayIndex = ESFileQueryUtils.getIndexName((LocalDate)LocalDate.now());
            String lastIndex = ESFileQueryUtils.getIndexName((LocalDate)((LocalDate)scanDates.get(0)));
            log.info(String.format("About to clone index [%s] to [%s] for files", lastIndex, todayIndex));
            this.indexRepository.cloneFileIndex(lastIndex, todayIndex);
        } else {
            this.createIndex(IndexType.FILE, indexingDate);
        }
    }

    public void createIndex(IndexType indexType, LocalDate indexingDate) throws NotFoundException {
        log.info(String.format("About to create index of type %s", indexType));
        try {
            this.indexRepository.createIndex(indexType, indexingDate);
        }
        catch (Exception e) {
            log.debug(String.format("Index mapping already created for type %s", indexType));
        }
    }

    public void refreshFileIndex(LocalDate indexingDate) {
        try {
            log.debug(String.format("Refreshing database for indexing date [%s]", indexingDate));
            this.indexRepository.refreshFileIndex(indexingDate);
        }
        catch (IOException e) {
            log.error(String.format("Error while refreshing database for indexing date [%s]", indexingDate));
        }
    }

    public void handleLongProcesses(String taskName) throws IOException {
        List taskInfos = this.indexRepository.getTasksByName(taskName);
        if (taskInfos.get(0) != null) {
            log.info(String.format("Task of type [%s] is still running with status [%s]", taskName, ((TaskInfo)taskInfos.get(0)).getStatus()));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private Set<LocalDate> getLocalDatesOfIndex(List<String> indexList) {
        HashSet<LocalDate> indexDates = new HashSet<LocalDate>();
        String regex = "\\d{4}-\\d{2}-\\d{2}";
        Pattern pattern = Pattern.compile(regex);
        indexList.forEach(indexName -> {
            Matcher matcher = pattern.matcher((CharSequence)indexName);
            if (matcher.find()) {
                try {
                    indexDates.add(LocalDate.parse(matcher.group(0)));
                }
                catch (DateTimeParseException e) {
                    log.warn(String.format("Unable to parse date for [%s]", matcher.group(0)));
                }
            }
        });
        return indexDates;
    }
}

