/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.ExcelValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class ExcelService {
    public File fillTemplateWithData(String templateName, List<ExcelValue> excelValueList) throws IOException {
        ClassPathResource resource = new ClassPathResource(String.format("reportTemplates/%s.xlsx", templateName));
        String tmpName = String.format("/tmp/reportTemplates-%s.xlsx", new Date().getTime());
        File tmpFile = new File(tmpName);
        FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)tmpFile);
        FileInputStream fileInputStream = new FileInputStream(tmpFile);
        Workbook workbook = WorkbookFactory.create((InputStream)fileInputStream);
        Sheet sheet = workbook.getSheetAt(0);
        for (ExcelValue excelValue : excelValueList) {
            Cell cell2Update;
            Row row = sheet.getRow(excelValue.getRow().intValue());
            if (row == null) {
                row = sheet.createRow(excelValue.getRow().intValue());
                cell2Update = row.createCell(excelValue.getCell().intValue());
            } else {
                cell2Update = row.getCell(excelValue.getCell().intValue());
            }
            if (cell2Update == null) {
                cell2Update = row.createCell(excelValue.getCell().intValue());
            }
            if (NumberUtils.isCreatable((String)excelValue.getValue())) {
                cell2Update.setCellValue(Double.parseDouble(excelValue.getValue()));
            } else {
                cell2Update.setCellValue(excelValue.getValue());
            }
            if (!excelValue.getCustomStyle().booleanValue()) continue;
            CellStyle style = workbook.createCellStyle();
            Font font = workbook.createFont();
            font.setBold(true);
            style.setFont(font);
            style.setAlignment(HorizontalAlignment.RIGHT);
            cell2Update.setCellStyle(style);
        }
        fileInputStream.close();
        String filename = String.format("/tmp/%s-%s.xlsx", templateName, new Date());
        FileOutputStream outputStream = new FileOutputStream(filename);
        workbook.write((OutputStream)outputStream);
        workbook.close();
        outputStream.close();
        return new File(filename);
    }
}

