/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.dataintell.visionapi.domain.MailRequest;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.service.ConfigurationService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    private final JavaMailSender sender;
    private final Configuration config;
    private final ConfigurationService configurationService;
    @Value(value="${spring.mail.username}")
    private String dataIntellEmail;

    public EmailService(JavaMailSender sender, Configuration config, ConfigurationService configurationService) {
        this.sender = sender;
        this.config = config;
        this.configurationService = configurationService;
    }

    public void sendEmailForNewUser(String username, String password, String email, String name) {
        String displayURL = "none";
        String appURL = "";
        try {
            io.dataintell.visionapi.domain.Configuration appURLConfiguration = this.configurationService.getConfigurationByName("app.url");
            displayURL = "block";
            appURL = appURLConfiguration.getValue();
        }
        catch (EntityNotFoundException e) {
            log.warn("No application configuration found in the configuration table", (Throwable)e);
        }
        Map templateValues = Map.ofEntries(Map.entry("hiddenUrl", displayURL), Map.entry("username", username), Map.entry("name", name), Map.entry("password", password), Map.entry("url", appURL), Map.entry("email", email));
        MailRequest mailRequest = new MailRequest(username, Collections.singletonList(email), this.dataIntellEmail, "DataIntell user access", Boolean.valueOf(true), null, null, Boolean.valueOf(true), templateValues);
        this.sendEmail(mailRequest, "new-user-access.ftl");
    }

    public void sendMail(String targetUserName, String targetEmail, String subject, String alertType, String storageName, List<String> paths, String usedSize, double percentageUsed, String totalSize, double percentageThreshold) {
        Map templateValues = Map.ofEntries(Map.entry("AlertType", alertType), Map.entry("storageName", storageName), Map.entry("alertType", alertType.toLowerCase()), Map.entry("storagePath", paths.toString()), Map.entry("usedSize", usedSize), Map.entry("percentageUsed", percentageUsed), Map.entry("totalSize", totalSize), Map.entry("percentageThreshold", percentageThreshold));
        MailRequest mailRequest = new MailRequest(targetUserName, Collections.singletonList(targetEmail), this.dataIntellEmail, subject, Boolean.valueOf(true), null, null, Boolean.valueOf(true), templateValues);
        this.sendEmail(mailRequest, "size-alert.ftl");
    }

    private void sendEmail(MailRequest mailRequest, String templateName) {
        try {
            MimeMessage message = this.sender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, 3, StandardCharsets.UTF_8.name());
            helper.setTo(mailRequest.getTo().toArray(new String[0]));
            helper.setSubject(mailRequest.getSubject());
            helper.setFrom(mailRequest.getFrom());
            if (mailRequest.getIsHTMLContent().booleanValue() && mailRequest.getUseTemplate().booleanValue()) {
                if (mailRequest.getTemplateValues() != null && mailRequest.getTemplateValues().size() > 0) {
                    Template template = this.config.getTemplate(templateName);
                    String html = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)mailRequest.getTemplateValues());
                    helper.setText(html, mailRequest.getIsHTMLContent().booleanValue());
                } else {
                    log.error("Template values not specified. In order to send email using templates, you must define the template values.");
                }
            } else {
                helper.setText(mailRequest.getText(), mailRequest.getIsHTMLContent().booleanValue());
            }
            if (mailRequest.getFilePathList() != null && mailRequest.getFilePathList().size() > 0) {
                for (String filePath : mailRequest.getFilePathList()) {
                    File file = new File(filePath);
                    FileSystemResource attachment = new FileSystemResource(file);
                    String fileName = new File(filePath).getName();
                    helper.addAttachment(fileName, (InputStreamSource)attachment);
                }
            }
            this.sender.send(message);
        }
        catch (TemplateException | IOException | MessagingException e) {
            log.error("There was a problem sending email for template {}", (Object)templateName, (Object)e);
        }
    }
}

