/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.FileStatistics;
import io.dataintell.visionapi.domain.FileStatisticsType;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.mapper.FileMapper;
import io.dataintell.visionapi.problem.ElasticsearchIOException;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.elasticsearch.DirectoryRepository;
import io.dataintell.visionapi.service.DirectoryService;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.utils.HashUtils;
import io.dataintell.visionapi.utils.SortUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DirectoryService {
    private static final Logger log = LoggerFactory.getLogger(DirectoryService.class);
    @Value(value="${app.file.statistics.size}")
    private Integer fileStatisticsSize;
    @Value(value="${app.scrollTimeToLive}")
    private Integer scrollTimeToLive;
    private final DirectoryRepository directoryRepository;
    private final IndexService indexService;
    private final FileMapper fileMapper;

    public DirectoryService(DirectoryRepository directoryRepository, IndexService indexService, FileMapper fileMapper) {
        this.directoryRepository = directoryRepository;
        this.indexService = indexService;
        this.fileMapper = fileMapper;
    }

    public PaginatedResult<File> getDirectories(String path, Long volumeId, Integer page, Integer size, String sort, Boolean showHiddenDirectories, LocalDate indexingDate) {
        try {
            Integer from = (page - 1) * size;
            String[] sortParameters = sort.split(",");
            String sortField = sortParameters[0];
            SortOrder direction = SortUtils.getESDirectionForSorting((String[])sortParameters);
            SearchResponse response = this.directoryRepository.getDirectoriesByPath(path, from, size, sortField, direction, showHiddenDirectories, volumeId, indexingDate);
            return this.fileMapper.getPaginatedResultWithSize(page.intValue(), size.intValue(), sortField, direction.toString(), response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public File getDirectory(String name, String path, Long volumeId, LocalDate indexingDate) throws IOException {
        String documentId = HashUtils.getDocumentId((String)name, (String)path, (Long)volumeId, (Boolean)true);
        GetResponse response = this.directoryRepository.getDirectoryByDocId(documentId, indexingDate);
        return this.fileMapper.getGsonFromJson(response);
    }

    public PaginatedResult<File> getDirectoriesWithScroll(String path, Long volumeId, Integer size, LocalDate indexingDate) throws IOException {
        SearchResponse response = this.directoryRepository.getDirectoriesWithScroll(path, volumeId, size, indexingDate, this.scrollTimeToLive);
        return this.fileMapper.getPaginatedResultWithScrollId(response);
    }

    public PaginatedResult<File> getNextListWithScroll(String scrollId) throws IOException {
        SearchResponse response = this.directoryRepository.getNextListWithScroll(scrollId, this.scrollTimeToLive);
        return this.fileMapper.getPaginatedResultWithScrollId(response);
    }

    public PaginatedResult<File> searchDirectoryByName(String name, Integer page, Integer size, LocalDate indexingDate) {
        try {
            SearchResponse response = this.directoryRepository.findPathByName(name, indexingDate, size);
            return this.fileMapper.getPaginatedResultWithSize(page.intValue(), size.intValue(), "size", "desc", response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public PaginatedResult<File> getSameDirectoryInformationAcrossTime(String path, Long volumeId, Integer page, Integer size, String sort) {
        try {
            Integer from = (page - 1) * size;
            String[] fieldAndDirection1 = sort.split(",");
            SortOrder direction1 = SortUtils.getESDirectionForSorting((String[])fieldAndDirection1);
            SearchResponse response = this.directoryRepository.getSameDirectoryInformationAcrossTime(path, from, size, volumeId, fieldAndDirection1[0], direction1);
            String sortField = fieldAndDirection1[0];
            String direction = direction1.toString();
            return this.fileMapper.getPaginatedResultWithSize(page.intValue(), size.intValue(), sortField, direction, response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public FileStatistics getDirectoryStatistics(String path, Long volumeId) {
        PaginatedResult paginatedResult = this.getSameDirectoryInformationAcrossTime(path, volumeId, Integer.valueOf(1), this.fileStatisticsSize, "indexingDate");
        List list = paginatedResult.getElements();
        if (list != null && list.size() > 0) {
            Date oldestLastAccessDate = ((File)list.get(0)).getLastAccess();
            Integer numberOfDifferentLastAccessDate = this.getNumberOfDifferentFileAttribute(list, FileStatisticsType.NUMBER_OF_DIFFERENT_LAST_ACCESS_DATE);
            Date oldestModifiedDate = ((File)list.get(0)).getLastModified();
            Integer numberOfDifferentModifiedDate = this.getNumberOfDifferentFileAttribute(list, FileStatisticsType.NUMBER_OF_DIFFERENT_MODIFIED_DATE);
            Date oldestCreationDate = ((File)list.get(0)).getCreationDate();
            Integer numberOfDifferentCreationDate = this.getNumberOfDifferentFileAttribute(list, FileStatisticsType.NUMBER_OF_DIFFERENT_CREATION_DATE);
            Integer numberOfDifferentOwner = this.getNumberOfDifferentFileAttribute(list, FileStatisticsType.NUMBER_OF_DIFFERENT_OWNER);
            Integer numberOfDifferentGroups = this.getNumberOfDifferentFileAttribute(list, FileStatisticsType.NUMBER_OF_DIFFERENT_GROUPS);
            Long smallestSize = ((File)list.get(0)).getSize();
            Long biggestSize = ((File)list.get(0)).getSize();
            for (File file : list) {
                if (smallestSize > file.getSize()) {
                    smallestSize = file.getSize();
                }
                if (biggestSize >= file.getSize()) continue;
                biggestSize = file.getSize();
            }
            Integer numberOfDifferentSizes = this.getNumberOfDifferentFileAttribute(list, FileStatisticsType.NUMBER_OF_DIFFERENT_SIZES);
            return new FileStatistics(path, numberOfDifferentLastAccessDate, oldestLastAccessDate, numberOfDifferentModifiedDate, oldestModifiedDate, numberOfDifferentCreationDate, oldestCreationDate, numberOfDifferentOwner, numberOfDifferentGroups, numberOfDifferentSizes, smallestSize, biggestSize, ((File)list.get(0)).getVolumeId(), ((File)list.get(0)).getVolumeName());
        }
        throw new EntityNotFoundException(File.class, String.format("Unable to find the directory with path [%s] and volume id [%s]", path, volumeId));
    }

    public void setDeletedFoldersAndFilesByPath(List<String> paths, Long volumeId, LocalDate indexingDate) throws IOException {
        try {
            this.directoryRepository.setDeletedFoldersAndFilesByPath(paths, volumeId, indexingDate);
        }
        catch (SocketTimeoutException e) {
            this.indexService.handleLongProcesses("indices:data/write/update/byquery");
        }
    }

    public PaginatedResult<File> getDeletedFoldersByScanDateWithScroll(Date scanDate, Long volumeId, LocalDate indexingDate) throws IOException {
        SearchResponse response = this.directoryRepository.getDeletedFoldersByScanDateWithScroll(Integer.valueOf(500), this.scrollTimeToLive, scanDate, volumeId, indexingDate);
        return this.fileMapper.getPaginatedResultWithScrollId(response);
    }

    private Integer getNumberOfDifferentFileAttribute(List<File> list, FileStatisticsType type) {
        HashSet<Object> set = new HashSet<Object>();
        for (int index = 0; index < list.size(); ++index) {
            Object o = this.getFileAttribute(type, list, index);
            set.add(o);
        }
        return set.size();
    }

    private Object getFileAttribute(FileStatisticsType type, List<File> list, int index) {
        Object o = null;
        switch (1.$SwitchMap$io$dataintell$visionapi$domain$FileStatisticsType[type.ordinal()]) {
            case 1: {
                o = list.get(index).getLastAccess();
                break;
            }
            case 2: {
                o = list.get(index).getLastModified();
                break;
            }
            case 3: {
                o = list.get(index).getCreationDate();
                break;
            }
            case 4: {
                o = list.get(index).getOwner();
                break;
            }
            case 5: {
                o = list.get(index).getGroup();
                break;
            }
            case 6: {
                o = list.get(index).getSize();
            }
        }
        return o;
    }
}

