/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.Configuration;
import io.dataintell.visionapi.entity.ConfigurationEntity;
import io.dataintell.visionapi.problem.BadRequestException;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.ConfigurationRepository;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.core.util.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationService.class);
    private final ConfigurationRepository repository;
    private static final String CRAWL_SCHEDULED = "crawl.scheduled";

    public ConfigurationService(ConfigurationRepository repository) {
        this.repository = repository;
    }

    public Configuration updateConfiguration(Long id, Configuration configuration) {
        if (CRAWL_SCHEDULED.equals(configuration.getName()) && !CronExpression.isValidExpression((String)configuration.getValue())) {
            LOGGER.error("Failure to update legacyscanner cron, [{}] is invalid", (Object)configuration.getValue());
            throw new BadRequestException("Invalid cron expression");
        }
        ConfigurationEntity configurationEntity = (ConfigurationEntity)this.repository.findById((Object)id).orElseThrow(this.notFound(String.valueOf(id)));
        configurationEntity.setValue(configuration.getValue());
        configurationEntity.setName(configuration.getName());
        configurationEntity.setDescription(configuration.getDescription());
        return this.toDto((ConfigurationEntity)this.repository.save((Object)configurationEntity));
    }

    public Configuration upsert(Configuration newConf) {
        ConfigurationEntity entity;
        Optional existing = this.repository.findOneByName(newConf.getName());
        if (existing.isPresent()) {
            entity = (ConfigurationEntity)existing.get();
            entity.setValue(newConf.getValue());
        } else {
            entity = new ConfigurationEntity(null, newConf.getName(), newConf.getDescription(), newConf.getValue());
        }
        return this.toDto((ConfigurationEntity)this.repository.save((Object)entity));
    }

    public List<Configuration> getConfigurations() {
        return StreamSupport.stream(this.repository.findAll().spliterator(), false).map(arg_0 -> this.toDto(arg_0)).collect(Collectors.toList());
    }

    public Configuration getConfigurationByName(String name) {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)this.repository.findOneByName(name).orElseThrow(this.notFound(name));
        return this.toDto(configurationEntity);
    }

    private Supplier<EntityNotFoundException> notFound(String id) {
        return () -> new EntityNotFoundException(ConfigurationEntity.class, id);
    }

    private Configuration toDto(ConfigurationEntity entity) {
        return new Configuration(entity.getId(), entity.getName(), entity.getDescription(), entity.getValue());
    }
}

