/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.CloudCredentials;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.BucketEntity;
import io.dataintell.visionapi.entity.VolumeSetting;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.S3BucketException;
import io.dataintell.visionapi.repository.BucketRepository;
import io.dataintell.visionapi.s3Scanner.S3ClientBuilder;
import io.dataintell.visionapi.schedule.ScheduleService;
import io.dataintell.visionapi.schedule.job.ScanBucketsJob;
import io.dataintell.visionapi.service.BucketCredentialsService;
import io.dataintell.visionapi.service.VolumeSettingService;
import io.dataintell.visionapi.utils.SortUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.S3Exception;

@Service
public class BucketService {
    private static final Logger log = LoggerFactory.getLogger(BucketService.class);
    private static final String BUCKETSID = "bucketsId";
    private final BucketRepository bucketRepository;
    private final VolumeSettingService volumeSettingService;
    private final ScheduleService scheduleService;
    private final BucketCredentialsService bucketCredentialsService;

    public BucketService(BucketRepository bucketRepository, VolumeSettingService volumeSettingService, ScheduleService scheduleService, BucketCredentialsService bucketCredentialsService) {
        this.bucketRepository = bucketRepository;
        this.volumeSettingService = volumeSettingService;
        this.scheduleService = scheduleService;
        this.bucketCredentialsService = bucketCredentialsService;
    }

    public io.dataintell.visionapi.domain.Bucket create(io.dataintell.visionapi.domain.Bucket bucket) {
        this.validateBucket(bucket);
        VolumeSetting volumeSetting = VolumeSetting.builder().name("S3-BUCKET-" + bucket.getDescription()).path("/").type("AWS-S3").storagePrice(bucket.getStoragePrice()).build();
        this.volumeSettingService.createVolumeSetting(volumeSetting);
        BucketEntity entity = this.toEntity(bucket);
        entity.setVolumeSettingId(volumeSetting.getId());
        return this.toDto((BucketEntity)this.bucketRepository.save((Object)entity));
    }

    public PaginatedResult<io.dataintell.visionapi.domain.Bucket> getAll(Integer page, Integer size, String sort) {
        String[] sortParameters = sort.split(",");
        Sort.Direction direction = SortUtils.getDirectionForSorting((String[])sortParameters);
        Page buckets = this.bucketRepository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortParameters[0]}))).map(arg_0 -> this.toDto(arg_0));
        return new PaginatedResult(buckets, direction.name().toLowerCase(), sortParameters[0], size);
    }

    public List<io.dataintell.visionapi.domain.Bucket> getAllNotPaginated() {
        List entities = (List)this.bucketRepository.findAll();
        return entities.stream().map(arg_0 -> this.toDto(arg_0)).collect(Collectors.toList());
    }

    public io.dataintell.visionapi.domain.Bucket get(int id) {
        return this.toDto((BucketEntity)this.bucketRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(BucketEntity.class, String.valueOf(id))));
    }

    public io.dataintell.visionapi.domain.Bucket update(int id, io.dataintell.visionapi.domain.Bucket bucket) {
        BucketEntity updatedEntity = (BucketEntity)this.bucketRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(BucketEntity.class, String.valueOf(id)));
        this.validateBucket(bucket);
        VolumeSetting volumeSetting = this.volumeSettingService.getVolumeSettingById(updatedEntity.getVolumeSettingId().longValue());
        volumeSetting.setName("S3-BUCKET-" + bucket.getDescription());
        volumeSetting.setStoragePrice(bucket.getStoragePrice());
        this.volumeSettingService.updateVolumeSetting(volumeSetting.getId(), volumeSetting);
        updatedEntity.setName(bucket.getName());
        updatedEntity.setDescription(bucket.getDescription());
        updatedEntity.setRegion(bucket.getRegion());
        updatedEntity.setAwsCredentialsId(bucket.getAwsCredentialsId().intValue());
        updatedEntity.setType(bucket.getType());
        return this.toDto((BucketEntity)this.bucketRepository.save((Object)updatedEntity));
    }

    public void delete(int id) {
        BucketEntity entity = (BucketEntity)this.bucketRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(BucketEntity.class, String.valueOf(id)));
        this.removeBucketIdFromJobs(id);
        this.bucketRepository.deleteById((Object)id);
        this.volumeSettingService.deleteVolumeSetting(entity.getVolumeSettingId());
    }

    public List<io.dataintell.visionapi.domain.Bucket> getAllBucketsInIds(List<Integer> bucketsId) {
        return this.bucketRepository.findByIdIn(bucketsId).stream().map(arg_0 -> this.toDto(arg_0)).collect(Collectors.toList());
    }

    public List<String> getListOfBucketsByCredentials(int credentialsId, String region, String namespace) {
        ArrayList<String> bucketNames = new ArrayList<String>();
        CloudCredentials credentials = this.bucketCredentialsService.getWithKeys(credentialsId);
        S3Client s3 = new S3ClientBuilder(credentials, region, namespace).build();
        try {
            ListBucketsResponse listBucketsResponse = s3.listBuckets();
            for (Bucket bucket : listBucketsResponse.buckets()) {
                String bucketName = bucket.name();
                HeadBucketRequest headBucketRequest = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build();
                try {
                    s3.headBucket(headBucketRequest);
                    bucketNames.add(bucketName);
                }
                catch (S3Exception e) {
                    log.warn("Bucket with name {} is not in region {}", (Object)bucketName, (Object)region);
                }
            }
        }
        catch (SdkClientException e) {
            String message = String.format("Error with region [%s]", region);
            log.error(message);
            throw new S3BucketException(message);
        }
        catch (S3Exception e) {
            String message = String.format("Error with credentials [%s] or region [%s]", credentials.getName(), region);
            log.error(message);
            throw new S3BucketException(message);
        }
        return bucketNames;
    }

    private void validateBucket(io.dataintell.visionapi.domain.Bucket bucket) {
        CloudCredentials credentials = this.bucketCredentialsService.getWithKeys(bucket.getAwsCredentialsId().intValue());
        try {
            S3Client s3Client = new S3ClientBuilder(bucket, credentials).build();
            HeadBucketRequest request = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucket.getBucketName()).build();
            s3Client.headBucket(request).sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchBucketException e) {
            String message = String.format("Bucket with name [%s] does not exist", bucket.getName());
            log.error(message);
            throw new S3BucketException(message);
        }
        catch (S3Exception e) {
            String message = String.format("Error with credentials with id [%s] for bucket with name [%s]", bucket.getAwsCredentialsId(), bucket.getName());
            log.error(message);
            throw new S3BucketException(message);
        }
        catch (SdkClientException e) {
            String message = String.format("Error with region [%s] for bucket with name [%s]", bucket.getRegion(), bucket.getName());
            log.error(message);
            throw new S3BucketException(message);
        }
    }

    private void removeBucketIdFromJobs(int id) {
        List schedules = this.scheduleService.getAllByJobClass(ScanBucketsJob.class.getName());
        schedules.forEach(schedule -> {
            List ids = (List)schedule.getPayload().get(BUCKETSID);
            if (ids.contains(id)) {
                if (ids.size() == 1) {
                    this.scheduleService.delete(schedule.getId().longValue());
                } else {
                    ids.remove((Object)id);
                    schedule.getPayload().replace(BUCKETSID, ids);
                    this.scheduleService.update(schedule.getId().longValue(), schedule);
                }
            }
        });
    }

    private io.dataintell.visionapi.domain.Bucket toDto(BucketEntity entity) {
        return io.dataintell.visionapi.domain.Bucket.builder().id(entity.getId()).name(entity.getName()).description(entity.getDescription()).region(entity.getRegion()).type(entity.getType()).volumeSettingId(entity.getVolumeSettingId()).awsCredentialsId(Integer.valueOf(entity.getAwsCredentialsId())).storagePrice(this.volumeSettingService.getVolumeSettingById(entity.getVolumeSettingId().longValue()).getStoragePrice()).build();
    }

    private BucketEntity toEntity(io.dataintell.visionapi.domain.Bucket bucket) {
        return BucketEntity.builder().name(bucket.getName()).description(bucket.getDescription()).region(bucket.getRegion()).type(bucket.getType()).volumeSettingId(bucket.getVolumeSettingId()).awsCredentialsId(bucket.getAwsCredentialsId().intValue()).build();
    }
}

