/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.Bucket;
import io.dataintell.visionapi.domain.CloudCredentials;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.AWSCredentialsEntity;
import io.dataintell.visionapi.mapper.BucketCredentialsMapper;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.SQLDeleteForeignKeyConstraintException;
import io.dataintell.visionapi.repository.AWSCredentialsRepository;
import io.dataintell.visionapi.utils.SortUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class BucketCredentialsService {
    private final AWSCredentialsRepository repository;
    private final BucketCredentialsMapper mapper;

    public BucketCredentialsService(AWSCredentialsRepository repository, BucketCredentialsMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }

    public CloudCredentials create(CloudCredentials credentials) {
        AWSCredentialsEntity entity = this.toEntity(credentials);
        return this.toDto((AWSCredentialsEntity)this.repository.save((Object)entity));
    }

    public PaginatedResult<AWSCredentialsEntity> getAll(Integer page, Integer size, String sort) {
        String[] sortParameters = sort.split(",");
        Sort.Direction direction = SortUtils.getDirectionForSorting((String[])sortParameters);
        Page entities = this.repository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortParameters[0]})));
        return this.mapper.getPaginatedResult(sortParameters[0], direction, entities, size);
    }

    public CloudCredentials read(int id) {
        return this.toDto((AWSCredentialsEntity)this.repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(AWSCredentialsEntity.class, String.valueOf(id))));
    }

    public CloudCredentials update(int id, CloudCredentials credentials) {
        AWSCredentialsEntity updatedCredentials = (AWSCredentialsEntity)this.repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(AWSCredentialsEntity.class, String.valueOf(id)));
        updatedCredentials.setName(credentials.getName());
        updatedCredentials.setAccessKey(credentials.getAccessKey());
        updatedCredentials.setPrivateKey(credentials.getPrivateKey());
        updatedCredentials.setType(credentials.getType());
        return this.toDto((AWSCredentialsEntity)this.repository.save((Object)updatedCredentials));
    }

    public void delete(int id) {
        this.repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(AWSCredentialsEntity.class, String.valueOf(id)));
        try {
            this.repository.deleteById((Object)id);
        }
        catch (DataIntegrityViolationException e) {
            throw new SQLDeleteForeignKeyConstraintException(AWSCredentialsEntity.class, String.valueOf(id), Bucket.class);
        }
    }

    public CloudCredentials getWithKeys(int id) {
        return this.toDtoWithKeys((AWSCredentialsEntity)this.repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(AWSCredentialsEntity.class, String.valueOf(id))));
    }

    private AWSCredentialsEntity toEntity(CloudCredentials credentials) {
        return AWSCredentialsEntity.builder().name(credentials.getName()).accessKey(credentials.getAccessKey()).privateKey(credentials.getPrivateKey()).type(credentials.getType()).build();
    }

    private CloudCredentials toDto(AWSCredentialsEntity entity) {
        return CloudCredentials.builder().id(entity.getId()).name(entity.getName()).type(entity.getType()).build();
    }

    private CloudCredentials toDtoWithKeys(AWSCredentialsEntity entity) {
        return CloudCredentials.builder().id(entity.getId()).name(entity.getName()).accessKey(entity.getAccessKey()).privateKey(entity.getPrivateKey()).type(entity.getType()).build();
    }
}

