/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.archiwareScanner.ArchiwareClient;
import io.dataintell.visionapi.archiwareScanner.ScanIndexHandler;
import io.dataintell.visionapi.domain.ArchiwareP5Credential;
import io.dataintell.visionapi.domain.ArchiwareP5Index;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.ArchiwareP5CredentialEntity;
import io.dataintell.visionapi.entity.ArchiwareP5IndexEntity;
import io.dataintell.visionapi.entity.Server;
import io.dataintell.visionapi.entity.VolumeSetting;
import io.dataintell.visionapi.file.BulkProcessorFactory;
import io.dataintell.visionapi.file.IngestFileProcessor;
import io.dataintell.visionapi.mapper.ArchiwareMapper;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.NotFoundException;
import io.dataintell.visionapi.problem.SQLDeleteForeignKeyConstraintException;
import io.dataintell.visionapi.problem.UniqueConstraintException;
import io.dataintell.visionapi.repository.ArchiwareP5CredentialRepository;
import io.dataintell.visionapi.repository.ArchiwareP5IndexRepository;
import io.dataintell.visionapi.security.PasswordEncrypt;
import io.dataintell.visionapi.service.ServerService;
import io.dataintell.visionapi.service.VolumeService;
import io.dataintell.visionapi.utils.SortUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;

@Service
public class ArchiwareService {
    private static final Logger log = LoggerFactory.getLogger(ArchiwareService.class);
    private final ArchiwareP5IndexRepository archiwareP5IndexRepository;
    private final ArchiwareP5CredentialRepository archiwareP5CredentialRepository;
    private final BulkProcessorFactory factory;
    private final VolumeService volumeService;
    private final ArchiwareMapper archiwareMapper;
    private final ServerService serverService;

    public ArchiwareService(ArchiwareP5IndexRepository archiwareP5IndexRepository, ArchiwareP5CredentialRepository archiwareP5CredentialRepository, BulkProcessorFactory factory, VolumeService volumeService, ArchiwareMapper archiwareMapper, ServerService serverService) {
        this.archiwareP5IndexRepository = archiwareP5IndexRepository;
        this.archiwareP5CredentialRepository = archiwareP5CredentialRepository;
        this.factory = factory;
        this.volumeService = volumeService;
        this.archiwareMapper = archiwareMapper;
        this.serverService = serverService;
    }

    public void scanArchiwareById(List<Long> archiwareIds) {
        List archiwareP5Indices = this.getAllArchiwareInIds(archiwareIds);
        archiwareP5Indices.forEach(archiware -> this.scanArchiwareByVolumeId(archiware.getVolumeSettingId()));
    }

    public void scanArchiwareByVolumeId(Long volumeSettingId) {
        ArchiwareP5IndexEntity archiwareP5IndexEntity = (ArchiwareP5IndexEntity)this.archiwareP5IndexRepository.findOneByVolumeSettingId(volumeSettingId).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5IndexEntity.class, String.valueOf(volumeSettingId)));
        ArchiwareP5Index archiwareP5Index = this.archiwareMapper.toDTOWithPassword(archiwareP5IndexEntity);
        LocalDate currentDate = LocalDate.now();
        IngestFileProcessor ingestFileProcessor = new IngestFileProcessor(this.factory.makeBulkProcessor(), currentDate, true);
        ScanIndexHandler scanIndexHandler = new ScanIndexHandler(archiwareP5Index, volumeSettingId.longValue(), archiwareP5IndexEntity.getVolumeSetting().getName(), ingestFileProcessor, this.volumeService);
        scanIndexHandler.scanArchiwareIndex();
        ingestFileProcessor.closeIngestProcessor();
    }

    public List<ArchiwareP5Index> getAllArchiwareInIds(List<Long> archiwareIds) {
        return this.archiwareP5IndexRepository.findByIdIn(archiwareIds).stream().map(arg_0 -> ((ArchiwareMapper)this.archiwareMapper).toDTO(arg_0)).collect(Collectors.toList());
    }

    public ArchiwareP5Index get(Long id) {
        return this.archiwareMapper.toDTO((ArchiwareP5IndexEntity)this.archiwareP5IndexRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5IndexEntity.class, String.valueOf(id))));
    }

    public PaginatedResult<ArchiwareP5Index> getAll(Integer page, Integer size, String sort, String direction) {
        Page archiwares = this.archiwareP5IndexRepository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)direction), (String[])new String[]{sort}))).map(arg_0 -> ((ArchiwareMapper)this.archiwareMapper).toDTO(arg_0));
        return new PaginatedResult(archiwares, direction, sort, size);
    }

    public List<ArchiwareP5Index> getAllNotPaginated() {
        List entities = (List)this.archiwareP5IndexRepository.findAll();
        return entities.stream().map(arg_0 -> ((ArchiwareMapper)this.archiwareMapper).toDTO(arg_0)).collect(Collectors.toList());
    }

    public ArchiwareP5Index create(ArchiwareP5Index archiwareP5Index) {
        Server server = this.serverService.getServerById(archiwareP5Index.getServerId().longValue());
        ArchiwareP5CredentialEntity archiwareP5CredentialEntity = this.getArchiwareP5CredentialEntity(archiwareP5Index);
        server.setId(archiwareP5Index.getServerId());
        VolumeSetting volumeSetting = VolumeSetting.builder().name(archiwareP5Index.getName()).path(archiwareP5Index.getPath()).type("Archiware").server(server).storagePrice(archiwareP5Index.getStoragePrice()).build();
        ArchiwareP5IndexEntity entity = this.archiwareMapper.toEntity(archiwareP5Index);
        entity.setArchiwareP5CredentialEntity(archiwareP5CredentialEntity);
        entity.setVolumeSetting(volumeSetting);
        try {
            return this.archiwareMapper.toDTO((ArchiwareP5IndexEntity)this.archiwareP5IndexRepository.save((Object)entity));
        }
        catch (DataIntegrityViolationException ex) {
            throw new UniqueConstraintException(ArchiwareP5Index.class, "name", archiwareP5Index.getName());
        }
    }

    public void deleteArchiwareP5Index(Long id) {
        this.archiwareP5IndexRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5IndexEntity.class, String.valueOf(id)));
        this.archiwareP5IndexRepository.deleteById((Object)id);
    }

    public ArchiwareP5Index update(Long id, ArchiwareP5Index archiwareP5Index) {
        ArchiwareP5IndexEntity updatedEntity = (ArchiwareP5IndexEntity)this.archiwareP5IndexRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5IndexEntity.class, String.valueOf(id)));
        Server server = this.serverService.getServerById(archiwareP5Index.getServerId().longValue());
        ArchiwareP5CredentialEntity archiwareP5CredentialEntity = this.getArchiwareP5CredentialEntity(archiwareP5Index);
        VolumeSetting volumeSetting = updatedEntity.getVolumeSetting();
        volumeSetting.setName(archiwareP5Index.getName());
        volumeSetting.setStoragePrice(archiwareP5Index.getStoragePrice());
        volumeSetting.setPath(archiwareP5Index.getPath());
        volumeSetting.setServer(server);
        updatedEntity.setIndexId(archiwareP5Index.getIndexId());
        updatedEntity.setPath(archiwareP5Index.getPath());
        updatedEntity.setArchiwareP5CredentialEntity(archiwareP5CredentialEntity);
        try {
            return this.archiwareMapper.toDTO((ArchiwareP5IndexEntity)this.archiwareP5IndexRepository.save((Object)updatedEntity));
        }
        catch (DataIntegrityViolationException ex) {
            throw new UniqueConstraintException(ArchiwareP5Index.class, "name", archiwareP5Index.getName());
        }
    }

    private ArchiwareP5CredentialEntity getArchiwareP5CredentialEntity(ArchiwareP5Index archiwareP5Index) {
        if (archiwareP5Index.getArchiwareP5Credential().getId() == null) {
            throw new EntityNotFoundException(ArchiwareP5CredentialEntity.class, "null");
        }
        ArchiwareP5CredentialEntity archiwareP5CredentialEntity = (ArchiwareP5CredentialEntity)this.archiwareP5CredentialRepository.findById((Object)archiwareP5Index.getArchiwareP5Credential().getId()).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5CredentialEntity.class, String.valueOf(archiwareP5Index.getArchiwareP5Credential().getId())));
        return archiwareP5CredentialEntity;
    }

    public List<String> getArchiwareIndexes(Long archiwareP5CredentialId) {
        ArchiwareP5CredentialEntity archiwareP5CredentialEntity = (ArchiwareP5CredentialEntity)this.archiwareP5CredentialRepository.findById((Object)archiwareP5CredentialId).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5IndexEntity.class, String.valueOf(archiwareP5CredentialId)));
        ArchiwareP5Credential archiwareP5Credential = this.archiwareMapper.toDTOWithPassword(archiwareP5CredentialEntity);
        return this.getArchiwareIndexes(archiwareP5Credential);
    }

    public List<String> getArchiwareIndexes(ArchiwareP5Credential archiwareBasicConfiguration) {
        List archiwareIndexes;
        ArchiwareClient archiwareClient = new ArchiwareClient(archiwareBasicConfiguration.getUrl(), archiwareBasicConfiguration.getUsername(), archiwareBasicConfiguration.getPassword());
        try {
            archiwareIndexes = archiwareClient.getArchiwareIndexes();
        }
        catch (HttpClientErrorException.NotFound | ResourceAccessException e) {
            throw new NotFoundException("Unable to communicate with Archiware Server", "url", archiwareBasicConfiguration.getUrl());
        }
        return archiwareIndexes;
    }

    public PaginatedResult<ArchiwareP5Credential> getAllCredentials(Integer page, Integer size, String sort) {
        String[] sortParameters = sort.split(",");
        Sort.Direction direction = SortUtils.getDirectionForSorting((String[])sortParameters);
        Page archiwareP5CredentialEntities = this.archiwareP5CredentialRepository.findAll((Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortParameters[0]})));
        return this.archiwareMapper.toPaginatedResults(archiwareP5CredentialEntities, sortParameters[0], direction, size);
    }

    public ArchiwareP5Credential create(ArchiwareP5Credential archiwareP5Credential) {
        archiwareP5Credential.setPassword(PasswordEncrypt.encrypt((String)archiwareP5Credential.getPassword()));
        ArchiwareP5CredentialEntity entity = this.archiwareMapper.toEntity(archiwareP5Credential);
        return this.archiwareMapper.toDTO((ArchiwareP5CredentialEntity)this.archiwareP5CredentialRepository.save((Object)entity));
    }

    public void deleteArchiwareP5Credential(Long id) {
        try {
            this.archiwareP5CredentialRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5IndexEntity.class, String.valueOf(id)));
            this.archiwareP5CredentialRepository.deleteById((Object)id);
        }
        catch (DataIntegrityViolationException e) {
            throw new SQLDeleteForeignKeyConstraintException(ArchiwareP5Credential.class, String.valueOf(id), ArchiwareP5Index.class);
        }
    }

    public ArchiwareP5Credential update(Long id, ArchiwareP5Credential archiwareP5Credential) {
        ArchiwareP5CredentialEntity updatedEntity = (ArchiwareP5CredentialEntity)this.archiwareP5CredentialRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(ArchiwareP5IndexEntity.class, String.valueOf(id)));
        updatedEntity.setName(archiwareP5Credential.getName());
        updatedEntity.setUsername(archiwareP5Credential.getUsername());
        updatedEntity.setUrl(archiwareP5Credential.getUrl());
        updatedEntity.setPassword(PasswordEncrypt.encrypt((String)archiwareP5Credential.getPassword()));
        return this.archiwareMapper.toDTO((ArchiwareP5CredentialEntity)this.archiwareP5CredentialRepository.save((Object)updatedEntity));
    }
}

