/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.service;

import io.dataintell.visionapi.domain.DetailedProjectPath;
import io.dataintell.visionapi.domain.User;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.service.EmailService;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.service.ProjectService;
import io.dataintell.visionapi.service.UserService;
import io.dataintell.visionapi.service.VolumeService;
import io.dataintell.visionapi.utils.NumberUtils;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlertService {
    private static final Logger log = LoggerFactory.getLogger(AlertService.class);
    private final IndexService indexService;
    private final VolumeService volumeService;
    private final ProjectService projectService;
    private final EmailService emailService;
    private final UserService userService;

    public AlertService(IndexService indexService, VolumeService volumeService, ProjectService projectService, EmailService emailService, UserService userService) {
        this.indexService = indexService;
        this.volumeService = volumeService;
        this.projectService = projectService;
        this.emailService = emailService;
        this.userService = userService;
    }

    @Transactional
    public void sendProjectSpaceAlert(int userId, List<Integer> projectIds, int threshold) {
        log.info("Project space alert for user id[{}], for projects[{}]", (Object)userId, projectIds);
        try {
            LocalDate indexingDate = (LocalDate)this.getIndexingDate().orElseThrow(() -> new EntityNotFoundException(LocalDate.class));
            User user = this.userService.getUserById_v1((long)userId);
            projectIds.stream().map(id -> {
                try {
                    return this.projectService.getDetailedProjectById((long)id.intValue(), indexingDate);
                }
                catch (EntityNotFoundException e) {
                    return null;
                }
            }).filter(Objects::nonNull).filter(exceedingProject -> exceedingProject.getSize().floatValue() / (float)exceedingProject.getAllocatedSize().longValue() * 100.0f >= (float)threshold).forEach(project -> {
                String subject = "Project space alert: " + project.getName();
                String alertType = "Project";
                String storageName = project.getName();
                List paths = project.getDetailedProjectPaths().stream().map(DetailedProjectPath::getPath).collect(Collectors.toList());
                String usedSize = FileUtils.byteCountToDisplaySize((long)project.getSize());
                long allocatedSizeInBytes = project.getAllocatedSize();
                double percUsage = project.getSize().floatValue() / (float)allocatedSizeInBytes * 100.0f;
                double percentageUsed = NumberUtils.getNumberWithDecimalPlaces((double)percUsage, (int)2, (int)4);
                String totalSize = FileUtils.byteCountToDisplaySize((long)project.getAllocatedSize());
                this.emailService.sendMail(user.getName(), user.getEmail(), subject, alertType, storageName, paths, usedSize, percentageUsed, totalSize, (double)threshold);
            });
        }
        catch (EntityNotFoundException e) {
            log.error(e.getMessage());
        }
    }

    @Transactional
    public void sendVolumeSpaceAlert(int userId, List<Integer> volumeIds, int threshold) {
        log.info("Volume space alert for user id[{}], for volumes[{}]", (Object)userId, volumeIds);
        try {
            User user = this.userService.getUserById_v1((long)userId);
            volumeIds.stream().map(id -> {
                try {
                    return this.volumeService.getVolumeById((long)id.intValue());
                }
                catch (EntityNotFoundException e) {
                    return null;
                }
            }).filter(Objects::nonNull).filter(volume -> volume.getUsed().floatValue() / (float)volume.getTotal().longValue() * 100.0f >= (float)threshold).forEach(exceedingVolume -> {
                String subject = "Volume space alert: " + exceedingVolume.getName();
                String alertType = "Volume";
                String storageName = exceedingVolume.getName();
                List<String> paths = Collections.singletonList(exceedingVolume.getPath());
                String usedSize = FileUtils.byteCountToDisplaySize((long)exceedingVolume.getUsed());
                double percUsage = exceedingVolume.getUsed().floatValue() / (float)exceedingVolume.getTotal().longValue() * 100.0f;
                double percentageUsed = NumberUtils.getNumberWithDecimalPlaces((double)percUsage, (int)2, (int)4);
                String totalSize = FileUtils.byteCountToDisplaySize((long)exceedingVolume.getTotal());
                this.emailService.sendMail(user.getName(), user.getEmail(), subject, alertType, storageName, paths, usedSize, percentageUsed, totalSize, (double)threshold);
            });
        }
        catch (EntityNotFoundException e) {
            log.error(e.getMessage());
        }
    }

    private Optional<LocalDate> getIndexingDate() {
        List crawlDates = this.indexService.getAllScanDates();
        if (crawlDates.size() == 0) {
            return Optional.empty();
        }
        return Optional.of((LocalDate)crawlDates.get(0));
    }
}

