/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.security;

import io.dataintell.visionapi.license.LicenseManager;
import io.dataintell.visionapi.security.UserPrincipal;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenProvider {
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenProvider.class);
    private final LicenseManager licenseManager;
    @Value(value="${app.jwtSecret}")
    private String jwtSecret;
    @Value(value="${app.jwtExpirationInMs}")
    private int jwtExpirationInMs;

    public JwtTokenProvider(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String generateToken(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Date now = new Date();
        Date expiryDate = new Date(now.getTime() + (long)this.jwtExpirationInMs);
        return Jwts.builder().setSubject(Long.toString(userPrincipal.getId())).setIssuedAt(new Date()).claim("userId", (Object)userPrincipal.getId()).claim("username", (Object)userPrincipal.getUsername()).claim("email", (Object)userPrincipal.getEmail()).claim("name", (Object)userPrincipal.getName()).claim("role", (Object)userPrincipal.getAuthorities()).claim("eulaValidation", (Object)userPrincipal.getEulaValidation()).claim("bundles", (Object)this.licenseManager.getLicense().getBundles()).setExpiration(expiryDate).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }

    public Long getUserIdFromJWT(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody();
        return Long.parseLong(claims.getSubject());
    }

    public boolean validateToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(authToken);
            return true;
        }
        catch (SignatureException ex) {
            logger.error("Invalid JWT signature");
        }
        catch (MalformedJwtException ex) {
            logger.error("Invalid JWT token");
        }
        catch (ExpiredJwtException ex) {
            logger.error("Expired JWT token");
        }
        catch (UnsupportedJwtException ex) {
            logger.error("Unsupported JWT token");
        }
        catch (IllegalArgumentException ex) {
            logger.error("JWT claims string is empty.");
        }
        return false;
    }
}

