/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.security;

import io.dataintell.visionapi.entity.UserEntity;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.UserRepository;
import io.dataintell.visionapi.security.UserPrincipal;
import java.util.function.Supplier;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomUserDetailsService
implements UserDetailsService {
    private final UserRepository userRepository;

    public CustomUserDetailsService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Transactional
    public UserDetails loadUserByUsername(String usernameOrEmail) {
        UserEntity user = (UserEntity)this.userRepository.findByUsernameOrEmail(usernameOrEmail, usernameOrEmail).orElseThrow(this.notFound(usernameOrEmail));
        return UserPrincipal.create((UserEntity)user);
    }

    @Transactional
    public UserDetails loadUserById(Long id) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)id).orElseThrow(this.notFound(String.valueOf(id)));
        return UserPrincipal.create((UserEntity)user);
    }

    private Supplier<EntityNotFoundException> notFound(String usernameOrEmail) {
        return () -> new EntityNotFoundException(UserEntity.class, usernameOrEmail);
    }
}

