/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.schedule.task;

import io.dataintell.visionapi.file.FileService;
import io.dataintell.visionapi.service.IndexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DeleteOldIndices {
    private static final Logger log = LoggerFactory.getLogger(DeleteOldIndices.class);
    private final IndexService indexService;
    private final FileService fileService;

    public DeleteOldIndices(IndexService indexService, FileService fileService) {
        this.indexService = indexService;
        this.fileService = fileService;
    }

    @Scheduled(cron="0 0 23 * * ?")
    public void deleteOldIndices() {
        try {
            this.indexService.deleteIndexBasedOnConfigurations();
            this.fileService.removeDeletedFilesOlderThan(Integer.valueOf(30));
        }
        catch (Exception e) {
            log.error("There was an error while deleting old indices", (Throwable)e);
        }
    }
}

