/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.schedule.job;

import io.dataintell.visionapi.service.ScanService;
import java.time.LocalDate;
import javassist.NotFoundException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.web.client.HttpClientErrorException;

@DisallowConcurrentExecution
public class ScanAllLocal
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(ScanAllLocal.class);
    private final ScanService service;
    private boolean cloneIndex;

    public ScanAllLocal(ScanService service) {
        this.service = service;
    }

    protected void executeInternal(JobExecutionContext context) {
        try {
            context.getMergedJobDataMap();
            this.service.scanAll(Boolean.valueOf(this.cloneIndex), LocalDate.now());
            log.info("All volumes were scanned");
        }
        catch (NotFoundException e) {
            log.error("The server is not configured correctly", (Throwable)e);
        }
        catch (HttpClientErrorException e) {
            log.error("One of the servers is busy scanning other volumes, try again later", (Throwable)e);
        }
        catch (Exception e) {
            log.error("An error occur while trying to scan all volumes", (Throwable)e);
        }
    }

    public void setCloneIndex(boolean cloneIndex) {
        this.cloneIndex = cloneIndex;
    }
}

