/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.schedule;

import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.ScheduleException;
import io.dataintell.visionapi.schedule.Schedule;
import io.dataintell.visionapi.schedule.ScheduleCreator;
import io.dataintell.visionapi.schedule.ScheduleRepository;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.transaction.Transactional;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;

@Service
public class ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleService.class);
    private final SchedulerFactoryBean schedulerFactoryBean;
    private final ScheduleCreator scheduleCreator;
    private final ApplicationContext context;
    private final ScheduleRepository repository;

    public ScheduleService(SchedulerFactoryBean schedulerFactoryBean, ScheduleCreator scheduleCreator, ApplicationContext context, ScheduleRepository repository) {
        this.schedulerFactoryBean = schedulerFactoryBean;
        this.scheduleCreator = scheduleCreator;
        this.context = context;
        this.repository = repository;
    }

    public Schedule getById(long id) {
        return (Schedule)this.repository.findById((Object)id).orElseThrow(this.notFound(id));
    }

    public List<Schedule> getAllByJobClass(String jobClass) {
        return this.repository.findAllByJobClass(jobClass);
    }

    public List<Schedule> getAll(Optional<String> jobGroup, Optional<Integer> userId) {
        if (jobGroup.isEmpty()) {
            return this.repository.findAll();
        }
        if (userId.isEmpty()) {
            return this.repository.findAllByJobGroup(jobGroup.get());
        }
        return this.repository.findAllByJobGroupAndUserId(jobGroup.get(), userId.get().intValue());
    }

    @Transactional
    public Schedule scheduleNewJob(Schedule schedule) {
        try {
            Schedule savedSchedule = (Schedule)this.repository.save((Object)schedule);
            Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
            JobDetail jobDetail = this.scheduleCreator.createJob(Class.forName(schedule.getJobClass()), true, this.context, String.valueOf(schedule.getId()), schedule.getJobGroup(), schedule.getPayload());
            String cron = schedule.getCron();
            CronTrigger trigger = this.scheduleCreator.createCronTrigger(jobDetail, new Date(), cron, 1);
            log.info("Scheduling new job[{}/{}] at[{}]", new Object[]{schedule.getJobGroup(), schedule.getName(), schedule.getCron()});
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            return savedSchedule;
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Class not found for [%s]", schedule.getJobClass());
            log.error(message);
            throw new ScheduleException(message);
        }
        catch (SchedulerException e) {
            String message = "Unable to schedule new scanner";
            log.error(message, (Throwable)e);
            throw new ScheduleException(message);
        }
    }

    @Transactional
    public Schedule update(long id, Schedule newSchedule) {
        Schedule schedule = (Schedule)this.repository.findById((Object)id).orElseThrow(this.notFound(id));
        try {
            Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
            JobKey jobKey = new JobKey(String.valueOf(schedule.getId()), schedule.getJobGroup());
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            if (null == jobDetail) {
                String message = String.format("Job not found for [%s/%s]", schedule.getJobGroup(), schedule.getName());
                log.error(message);
                throw new ScheduleException(message);
            }
            log.info("Updating cron to [{}] for scanner [{},{}]", new Object[]{newSchedule.getCron(), schedule.getJobGroup(), schedule.getName()});
            CronTrigger newTrigger = this.scheduleCreator.createCronTrigger(jobDetail, new Date(), newSchedule.getCron(), 1);
            this.schedulerFactoryBean.getScheduler().rescheduleJob(TriggerKey.triggerKey((String)String.valueOf(schedule.getId())), (Trigger)newTrigger);
            JobDetail newJobDetail = this.scheduleCreator.createJob(Class.forName(schedule.getJobClass()), true, this.context, String.valueOf(schedule.getId()), schedule.getJobGroup(), newSchedule.getPayload());
            scheduler.addJob(newJobDetail, true);
            schedule.setName(newSchedule.getName());
            schedule.setPayload(newSchedule.getPayload());
            schedule.setCron(newSchedule.getCron());
            return (Schedule)this.repository.save((Object)schedule);
        }
        catch (SchedulerException e) {
            String message = String.format("Unable to update cron for schedule id[%s]", id);
            log.error(message, (Throwable)e);
            throw new ScheduleException(message);
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Class not found for [%s]", schedule.getJobClass());
            log.error(message);
            throw new ScheduleException(message);
        }
    }

    @Transactional
    public boolean delete(long id) {
        try {
            log.info("Deleting schedule with id[{}]", (Object)id);
            Schedule schedule = (Schedule)this.repository.findById((Object)id).orElseThrow(this.notFound(id));
            this.repository.delete((Object)schedule);
            JobKey jobKey = new JobKey(String.valueOf(schedule.getId()), schedule.getJobGroup());
            return this.schedulerFactoryBean.getScheduler().deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            String message = String.format("Unable to delete schedule with it[%s]", id);
            log.error(message, (Throwable)e);
            throw new ScheduleException(message);
        }
    }

    public void pauseAll() {
        try {
            Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
            scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            log.error("Unable to pause job scheduler", (Throwable)e);
        }
    }

    public void resumeAll() {
        try {
            Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
            scheduler.resumeAll();
        }
        catch (SchedulerException e) {
            log.error("Unable to resume job scheduler", (Throwable)e);
        }
    }

    private Supplier<EntityNotFoundException> notFound(long id) {
        return () -> new EntityNotFoundException(Schedule.class, String.valueOf(id));
    }
}

