/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.schedule;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class ScheduleCreator {
    private static final Logger log = LoggerFactory.getLogger(ScheduleCreator.class);

    JobDetail createJob(Class<? extends QuartzJobBean> jobClass, boolean isDurable, ApplicationContext context, String jobName, String jobGroup, Map<String, Object> data) {
        JobDetailFactoryBean factoryBean = new JobDetailFactoryBean();
        factoryBean.setJobClass(jobClass);
        factoryBean.setDurability(isDurable);
        factoryBean.setApplicationContext(context);
        factoryBean.setName(jobName);
        factoryBean.setGroup(jobGroup);
        if (null != data) {
            factoryBean.setJobDataMap(new JobDataMap(data));
        }
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }

    CronTrigger createCronTrigger(JobDetail jobDetail, Date startTime, String cronExpression, int misFireInstruction) {
        CronTriggerFactoryBean factoryBean = new CronTriggerFactoryBean();
        factoryBean.setName(jobDetail.getKey().getName());
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setStartTime(startTime);
        factoryBean.setCronExpression(cronExpression);
        factoryBean.setMisfireInstruction(misFireInstruction);
        try {
            factoryBean.afterPropertiesSet();
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return factoryBean.getObject();
    }
}

