/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.schedule;

import io.dataintell.visionapi.schedule.Schedule;
import io.dataintell.visionapi.schedule.ScheduleService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Hidden
public class ScheduleController {
    private final ScheduleService service;

    public ScheduleController(ScheduleService service) {
        this.service = service;
    }

    @GetMapping(value={"v1/schedules/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get schedule by id", hidden=true)
    public Schedule getById(@PathVariable(value="id") long id) {
        return this.service.getById(id);
    }

    @GetMapping(value={"v1/schedules"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all schedules", hidden=true)
    public List<Schedule> getAll(@RequestParam(value="jobGroup", required=false) Optional<String> jobGroup, @RequestParam(value="userId", required=false) Optional<Integer> userId) {
        return this.service.getAll(jobGroup, userId);
    }

    @PostMapping(value={"v1/schedules"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create schedule", hidden=true)
    public Schedule create(@RequestBody @Valid Schedule schedule) {
        return this.service.scheduleNewJob(schedule);
    }

    @PutMapping(value={"v1/schedules/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update schedule", hidden=true)
    public Schedule update(@PathVariable(value="id") long id, @RequestBody @Valid Schedule schedule) {
        return this.service.update(id, schedule);
    }

    @DeleteMapping(value={"v1/schedules/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete schedule by id", hidden=true)
    public boolean delete(@PathVariable(value="id") long id) {
        return this.service.delete(id);
    }
}

