/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.scanner;

import io.dataintell.visionapi.domain.ArchiwareP5Index;
import io.dataintell.visionapi.domain.Bucket;
import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.domain.Job;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.Server;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.JobRepository;
import io.dataintell.visionapi.scanner.DeletedFilesManager;
import io.dataintell.visionapi.scanner.DuplicateFilesManager;
import io.dataintell.visionapi.scanner.JobBundle;
import io.dataintell.visionapi.scanner.JobEntity;
import io.dataintell.visionapi.scanner.JobMapper;
import io.dataintell.visionapi.scanner.JobService;
import io.dataintell.visionapi.scanner.JobStatus;
import io.dataintell.visionapi.scanner.JobType;
import io.dataintell.visionapi.scanner.ScanArchiwarePayload;
import io.dataintell.visionapi.scanner.ScanBucketPayload;
import io.dataintell.visionapi.scanner.ScanVolumePayload;
import io.dataintell.visionapi.scanner.VolumeSetting;
import io.dataintell.visionapi.service.ArchiwareService;
import io.dataintell.visionapi.service.BucketService;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.service.ProjectService;
import io.dataintell.visionapi.service.ServerService;
import io.dataintell.visionapi.service.VolumeSettingService;
import io.dataintell.visionapi.utils.TransferTagsManager;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class JobService {
    private static final Logger log = LoggerFactory.getLogger(JobService.class);
    @Value(value="${dataintell.server.scannerMaxDelay}")
    private Long scannerMaxDelay;
    private static final Map<Long, JobBundle> jobBundles = new Hashtable();
    private final JobRepository jobRepository;
    private final VolumeSettingService volumeSettingService;
    private final ServerService serverService;
    private final IndexService indexService;
    private final ProjectService projectService;
    private final DuplicateFilesManager duplicateFilesManager;
    private final TransferTagsManager transferTagsManager;
    private final DeletedFilesManager deletedFilesManager;
    private final JobMapper jobMapper;
    private final BucketService bucketService;
    private final ArchiwareService archiwareService;

    public JobService(JobRepository jobRepository, VolumeSettingService volumeSettingService, ServerService serverService, IndexService indexService, ProjectService projectService, DuplicateFilesManager duplicateFilesManager, TransferTagsManager transferTagsManager, DeletedFilesManager deletedFilesManager, JobMapper jobMapper, BucketService bucketService, ArchiwareService archiwareService) {
        this.jobRepository = jobRepository;
        this.volumeSettingService = volumeSettingService;
        this.serverService = serverService;
        this.indexService = indexService;
        this.projectService = projectService;
        this.duplicateFilesManager = duplicateFilesManager;
        this.transferTagsManager = transferTagsManager;
        this.deletedFilesManager = deletedFilesManager;
        this.jobMapper = jobMapper;
        this.bucketService = bucketService;
        this.archiwareService = archiwareService;
    }

    public Job<?> findById(long id) {
        JobEntity entity = (JobEntity)this.jobRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(JobEntity.class, String.valueOf(id)));
        return this.jobMapper.toDTO(entity);
    }

    public PaginatedResult<Job<?>> findAll(int page, int size, String sort, String direction) {
        Page jobs = this.jobRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)direction), (String[])new String[]{sort}))).map(arg_0 -> ((JobMapper)this.jobMapper).toDTO(arg_0));
        return new PaginatedResult(jobs, direction, sort, Integer.valueOf(size));
    }

    public Job<?> create(Job<?> job) {
        return this.jobMapper.toDTO((JobEntity)this.jobRepository.save((Object)this.jobMapper.toEntity(job)));
    }

    public Job<?> update(Long id, Job<?> job) {
        JobEntity entity = (JobEntity)this.jobRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(JobEntity.class, String.valueOf(id)));
        entity.setStatus(job.getStatus());
        entity.setServerId(job.getServerId());
        entity.setPayload(this.jobMapper.payloadToJson(job.getPayload()));
        entity.setType(job.getType());
        entity.setCreatedAt(job.getCreatedAt());
        entity.setUpdatedAt(job.getUpdatedAt());
        return this.jobMapper.toDTO((JobEntity)this.jobRepository.save((Object)entity));
    }

    public Job<?> dispatchScanVolume(long volumeId, boolean cloneIndex) {
        LocalDate indexingDate = LocalDate.now();
        io.dataintell.visionapi.entity.VolumeSetting vol = this.volumeSettingService.getVolumeSettingById(volumeId);
        ScanVolumePayload payload = new ScanVolumePayload(indexingDate, this.isFirstScanOfTheDay(indexingDate), Collections.singletonList(new VolumeSetting(vol.getId().longValue(), vol.getName(), vol.getPath(), vol.getType(), vol.getLastScan())));
        Long serverId = vol.getServer().getId();
        Job newJob = this.create(Job.builder().status(JobStatus.NEW).payload((Object)payload).serverId(serverId.longValue()).type(JobType.SCAN_VOLUME).build());
        jobBundles.put(newJob.getId(), new JobBundle(newJob));
        this.runPreScanAsync(newJob, cloneIndex, indexingDate);
        log.info("Dispatching Scan Volumes scanner for volume id:{}", (Object)vol.getId());
        return newJob;
    }

    public List<Job<?>> dispatchScanVolumes(List<Long> volumeIds, boolean cloneIndex) {
        LocalDate indexingDate = LocalDate.now();
        List volumeSettingEntities = this.volumeSettingService.getAllVolumesInIds(volumeIds);
        Map groupedByServer = this.groupByServer(volumeSettingEntities);
        List<Job<?>> createdJobs = groupedByServer.keySet().stream().map(serverId -> {
            List volumes = (List)groupedByServer.get(serverId);
            ScanVolumePayload payload = new ScanVolumePayload(indexingDate, this.isFirstScanOfTheDay(indexingDate), this.toDTO(volumes));
            return this.create(Job.builder().status(JobStatus.NEW).payload((Object)payload).serverId(serverId.longValue()).type(JobType.SCAN_VOLUME).build());
        }).collect(Collectors.toList());
        JobBundle bundle = new JobBundle(createdJobs);
        createdJobs.forEach(job -> {
            jobBundles.put(job.getId(), bundle);
            this.runPreScanAsync(job, cloneIndex, indexingDate);
        });
        return createdJobs;
    }

    public Job<?> dispatchScanServer(long serverId, boolean cloneIndex) {
        LocalDate indexingDate = LocalDate.now();
        Server server = this.serverService.getServerById(serverId);
        List volumeSettingEntities = this.volumeSettingService.getAllVolumesByServerIdAndType(serverId, "crawl.files");
        ScanVolumePayload payload = new ScanVolumePayload(indexingDate, this.isFirstScanOfTheDay(indexingDate), this.toDTO(volumeSettingEntities));
        Job newJob = this.create(Job.builder().status(JobStatus.NEW).payload((Object)payload).serverId(serverId).type(JobType.SCAN_VOLUME).build());
        jobBundles.put(newJob.getId(), new JobBundle(newJob));
        this.runPreScanAsync(newJob, cloneIndex, indexingDate);
        log.info("Dispatching Scan Volumes scanner for server id:{}, name:{}", (Object)server.getId(), (Object)server.getName());
        return newJob;
    }

    public List<Job<?>> dispatchScanAll(boolean cloneIndex) {
        LocalDate indexingDate = LocalDate.now();
        List<Job<?>> createdJobs = this.serverService.getAllServers().stream().map(server -> {
            List volumeSettingEntities = this.volumeSettingService.getAllVolumesByServerIdAndType(server.getId().longValue(), "crawl.files");
            ScanVolumePayload payload = new ScanVolumePayload(indexingDate, this.isFirstScanOfTheDay(indexingDate), this.toDTO(volumeSettingEntities));
            return this.create(Job.builder().status(JobStatus.NEW).payload((Object)payload).serverId(server.getId().longValue()).type(JobType.SCAN_VOLUME).build());
        }).collect(Collectors.toList());
        JobBundle bundle = new JobBundle(createdJobs);
        createdJobs.forEach(job -> {
            jobBundles.put(job.getId(), bundle);
            this.runPreScanAsync(job, cloneIndex, indexingDate);
        });
        return createdJobs;
    }

    public Job<?> dispatchScanBuckets(List<Integer> bucketIds, boolean cloneIndex) {
        LocalDate indexingDate = LocalDate.now();
        ScanBucketPayload payload = new ScanBucketPayload(indexingDate, bucketIds, this.isFirstScanOfTheDay(indexingDate));
        Job newJob = this.create(Job.builder().status(JobStatus.NEW).payload((Object)payload).type(JobType.SCAN_BUCKET).build());
        jobBundles.put(newJob.getId(), new JobBundle(newJob));
        this.runPreScanAsync(newJob, cloneIndex, indexingDate);
        log.info("Dispatching scan for buckets");
        return newJob;
    }

    public Job<?> dispatchScanArchiwares(List<Long> archiwareIds, boolean cloneIndex) {
        LocalDate indexingDate = LocalDate.now();
        ScanArchiwarePayload payload = new ScanArchiwarePayload(indexingDate, archiwareIds, this.isFirstScanOfTheDay(indexingDate));
        Job newJob = this.create(Job.builder().status(JobStatus.NEW).payload((Object)payload).type(JobType.SCAN_ARCHIWARE).build());
        jobBundles.put(newJob.getId(), new JobBundle(newJob));
        this.runPreScanAsync(newJob, cloneIndex, indexingDate);
        log.info("Dispatching scan for archiwares");
        return newJob;
    }

    public Job<?> dispatchScanAllBuckets(boolean cloneIndex) {
        List bucketIds = this.bucketService.getAllNotPaginated().stream().map(Bucket::getId).collect(Collectors.toList());
        return this.dispatchScanBuckets(bucketIds, cloneIndex);
    }

    public Job<?> dispatchScanAllArchiwares(boolean cloneIndex) {
        List archiwareIds = this.archiwareService.getAllNotPaginated().stream().map(ArchiwareP5Index::getId).collect(Collectors.toList());
        return this.dispatchScanArchiwares(archiwareIds, cloneIndex);
    }

    public void onJobNotification(long jobId) throws IOException, InterruptedException {
        JobBundle bundle = (JobBundle)jobBundles.get(jobId);
        if (null == bundle) {
            return;
        }
        Job job = this.findById(jobId);
        log.info("Executing post-scan routine for scanner id:{}", (Object)jobId);
        Job postScanJob = this.postScanRoutine(job);
        bundle.save(postScanJob);
        this.update(Long.valueOf(jobId), postScanJob);
        jobBundles.remove(jobId);
        log.info("Completed post-scan routine for scanner id:{}", (Object)jobId);
    }

    private void runPreScanAsync(Job<?> job, boolean cloneIndex, LocalDate indexingDate) {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                this.indexService.createFileIndex(indexingDate, cloneIndex);
                this.indexService.createIndex(IndexType.VOLUME, indexingDate);
                this.indexService.createIndex(IndexType.PROJECT, indexingDate);
                this.projectService.indexAllProjects(indexingDate);
            }
            catch (IOException | InterruptedException | NotFoundException e) {
                log.error("Unable to create indices for indexingDate[{}], cloneIndex[{}]", new Object[]{indexingDate, cloneIndex, e});
            }
            return null;
        }).thenRunAsync(() -> {
            job.setStatus(JobStatus.AVAILABLE);
            this.update(job.getId(), job);
        })).thenRunAsync(() -> {
            try {
                Thread.sleep(this.scannerMaxDelay);
                JobEntity updatedJobEntity = (JobEntity)this.jobRepository.findById((Object)job.getId()).get();
                if (JobStatus.AVAILABLE == updatedJobEntity.getStatus()) {
                    updatedJobEntity.setStatus(JobStatus.SCANNER_ERROR);
                    this.jobRepository.save((Object)updatedJobEntity);
                }
            }
            catch (InterruptedException e) {
                log.error("Unable to execute stale scanner[{}] detection routine", (Object)job.getId(), (Object)e);
            }
        });
    }

    private Job<?> postScanRoutine(Job<?> job) {
        job.setUpdatedAt(Instant.now());
        JobStatus status = job.getStatus();
        if (JobStatus.SCANNER_COMPLETED == status) {
            job.setStatus(JobStatus.SUCCESS);
        } else if (JobStatus.SCANNER_ERROR == status) {
            job.setStatus(JobStatus.FAILURE);
            return job;
        }
        switch (1.$SwitchMap$io$dataintell$visionapi$scanner$JobType[job.getType().ordinal()]) {
            case 1: {
                this.postScanVolumeRoutine(job);
                break;
            }
            case 2: {
                this.postScanBucketRoutine(job);
                break;
            }
            case 3: {
                this.postScanArchiwareRoutine(job);
                break;
            }
        }
        return job;
    }

    private void postScanArchiwareRoutine(Job<?> job) {
        ScanArchiwarePayload scanArchiwarePayload = (ScanArchiwarePayload)job.getPayload();
        List volumeIds = this.archiwareService.getAllArchiwareInIds(scanArchiwarePayload.getArchiwareIds()).stream().map(ArchiwareP5Index::getVolumeSettingId).collect(Collectors.toList());
        List pastScanDate = this.indexService.getAllScanDates();
        this.indexService.refreshFileIndex(scanArchiwarePayload.getIndexingDate());
        this.deletedFilesManager.tagDeletedFilesForVolumesAfterFullScan(volumeIds, Date.from(job.getCreatedAt()), scanArchiwarePayload.getIndexingDate());
        if (scanArchiwarePayload.isFirstScanOfTheDay()) {
            this.transferTagsManager.transferTagsToNextScanDate((LocalDate)pastScanDate.get(1), scanArchiwarePayload.getIndexingDate());
        }
        this.duplicateFilesManager.tagDuplicatedFilesAfterFullScan(volumeIds, scanArchiwarePayload.getIndexingDate());
        this.indexService.refreshFileIndex(scanArchiwarePayload.getIndexingDate());
        this.projectService.indexAllProjects(scanArchiwarePayload.getIndexingDate());
    }

    private void postScanVolumeRoutine(Job<?> job) {
        ScanVolumePayload payload = (ScanVolumePayload)job.getPayload();
        payload.getVolumeSettings().stream().map(dto -> this.volumeSettingService.getVolumeSettingById(dto.getId())).filter(Objects::nonNull).forEach(volumeSetting -> {
            volumeSetting.setLastScan(Date.from(job.getCreatedAt()));
            this.volumeSettingService.updateVolumeSetting(volumeSetting.getId(), volumeSetting);
        });
        List volumeIds = payload.getVolumeSettings().stream().map(VolumeSetting::getId).collect(Collectors.toList());
        this.indexService.refreshFileIndex(payload.getIndexingDate());
        List pastScanDate = this.indexService.getAllScanDates();
        if (payload.isFirstScanOfTheDay()) {
            this.deletedFilesManager.tagDeletedFilesForVolumesAfterFullScan(volumeIds, Date.from(job.getCreatedAt()), payload.getIndexingDate());
            this.transferTagsManager.transferTagsToNextScanDate((LocalDate)pastScanDate.get(1), payload.getIndexingDate());
            this.duplicateFilesManager.tagDuplicatedFilesForVolumesAfterFullScanForOnPremise(volumeIds, payload.getIndexingDate());
        } else {
            this.duplicateFilesManager.tagDuplicatedFilesForVolumesAfterDeltaScan(volumeIds, payload.getIndexingDate());
        }
        this.indexService.refreshFileIndex(payload.getIndexingDate());
        this.projectService.indexAllProjects(payload.getIndexingDate());
    }

    private void postScanBucketRoutine(Job<?> job) {
        ScanBucketPayload scanBucketPayload = (ScanBucketPayload)job.getPayload();
        List buckets = this.bucketService.getAllBucketsInIds(scanBucketPayload.getBucketIds());
        List volumeIds = buckets.stream().map(Bucket::getVolumeSettingId).collect(Collectors.toList());
        List pastScanDate = this.indexService.getAllScanDates();
        this.indexService.refreshFileIndex(scanBucketPayload.getIndexingDate());
        this.deletedFilesManager.tagDeletedFilesForVolumesAfterFullScan(volumeIds, Date.from(job.getCreatedAt()), scanBucketPayload.getIndexingDate());
        if (scanBucketPayload.isFirstScanOfTheDay()) {
            this.transferTagsManager.transferTagsToNextScanDate((LocalDate)pastScanDate.get(1), scanBucketPayload.getIndexingDate());
        }
        this.duplicateFilesManager.tagDuplicatedFilesAfterFullScan(volumeIds, scanBucketPayload.getIndexingDate());
        this.indexService.refreshFileIndex(scanBucketPayload.getIndexingDate());
        this.projectService.indexAllProjects(scanBucketPayload.getIndexingDate());
    }

    private Map<Long, List<io.dataintell.visionapi.entity.VolumeSetting>> groupByServer(List<io.dataintell.visionapi.entity.VolumeSetting> allVolumesInIds) {
        HashMap<Long, List<io.dataintell.visionapi.entity.VolumeSetting>> grouped = new HashMap<Long, List<io.dataintell.visionapi.entity.VolumeSetting>>();
        for (io.dataintell.visionapi.entity.VolumeSetting volume : allVolumesInIds) {
            Long serverId = volume.getServer().getId();
            if (grouped.containsKey(serverId)) {
                grouped.get(serverId).add(volume);
                continue;
            }
            ArrayList<io.dataintell.visionapi.entity.VolumeSetting> list = new ArrayList<io.dataintell.visionapi.entity.VolumeSetting>();
            list.add(volume);
            grouped.put(serverId, list);
        }
        return grouped;
    }

    private boolean isFirstScanOfTheDay(LocalDate currentScanDate) {
        List pastScanDate = this.indexService.getAllScanDates();
        return !pastScanDate.isEmpty() && !((LocalDate)pastScanDate.get(0)).equals(currentScanDate);
    }

    private List<VolumeSetting> toDTO(List<io.dataintell.visionapi.entity.VolumeSetting> volumeSettingEntities) {
        return volumeSettingEntities.stream().map(vs -> VolumeSetting.builder().id(vs.getId().longValue()).name(vs.getName()).path(vs.getPath()).type(vs.getType()).lastScan(vs.getLastScan()).build()).collect(Collectors.toList());
    }
}

