/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.scanner;

import io.dataintell.visionapi.domain.Job;
import io.dataintell.visionapi.repository.JobRepository;
import io.dataintell.visionapi.scanner.JobMapper;
import io.dataintell.visionapi.scanner.JobProcessor;
import io.dataintell.visionapi.scanner.JobService;
import io.dataintell.visionapi.scanner.JobStatus;
import io.dataintell.visionapi.scanner.JobType;
import io.dataintell.visionapi.scanner.ScanArchiwarePayload;
import io.dataintell.visionapi.scanner.ScanBucketPayload;
import io.dataintell.visionapi.service.ArchiwareService;
import io.dataintell.visionapi.service.ScanBucketService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;

@Async
public class JobProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JobProcessor.class);
    @Autowired
    private JobService jobService;
    @Autowired
    private ScanBucketService scanBucketService;
    @Autowired
    private ArchiwareService archiwareService;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JobMapper jobMapper;

    public void processJobSuccess(String payload) {
        logger.info("Received notification from scanner id[{}]", (Object)payload);
        try {
            this.jobService.onJobNotification(Long.parseLong(payload));
        }
        catch (IOException | InterruptedException e) {
            logger.error("Unable to parse scanner id", (Throwable)e);
        }
    }

    public void processNewJob(String payload) {
        long id = Long.parseLong(payload);
        Job job = this.jobService.findById(id);
        if (JobType.SCAN_VOLUME != job.getType() && JobStatus.AVAILABLE == job.getStatus()) {
            job.setStatus(JobStatus.SCANNER_RUNNING);
            this.jobRepository.save((Object)this.jobMapper.toEntity(job));
            this.scanJob(job);
            job.setStatus(JobStatus.SCANNER_COMPLETED);
            this.jobRepository.save((Object)this.jobMapper.toEntity(job));
        }
    }

    private void scanJob(Job<?> job) {
        switch (1.$SwitchMap$io$dataintell$visionapi$scanner$JobType[job.getType().ordinal()]) {
            case 1: {
                ScanBucketPayload scanBucketPayload = (ScanBucketPayload)job.getPayload();
                this.scanBucketService.scanBucketsById(scanBucketPayload.getBucketIds(), scanBucketPayload.isFirstScanOfTheDay());
                break;
            }
            case 2: {
                ScanArchiwarePayload scanArchiwarePayload = (ScanArchiwarePayload)job.getPayload();
                this.archiwareService.scanArchiwareById(scanArchiwarePayload.getArchiwareIds());
                break;
            }
        }
    }
}

