/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.scanner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dataintell.visionapi.domain.Job;
import io.dataintell.visionapi.problem.MappingException;
import io.dataintell.visionapi.scanner.JobEntity;
import io.dataintell.visionapi.scanner.JobMapper;
import io.dataintell.visionapi.scanner.JobType;
import io.dataintell.visionapi.scanner.ScanArchiwarePayload;
import io.dataintell.visionapi.scanner.ScanBucketPayload;
import io.dataintell.visionapi.scanner.ScanVolumePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobMapper {
    private static final Logger log = LoggerFactory.getLogger(JobMapper.class);

    public Job<?> toDTO(JobEntity entity) {
        return Job.builder().id(entity.getId()).status(entity.getStatus()).serverId(entity.getServerId()).payload(this.payloadToObject(entity.getPayload(), this.jobTypeToClass(entity.getType()))).type(entity.getType()).createdAt(entity.getCreatedAt()).updatedAt(entity.getUpdatedAt()).build();
    }

    public JobEntity toEntity(Job<?> job) {
        JobEntity entity = JobEntity.builder().id(job.getId()).status(job.getStatus()).serverId(job.getServerId()).payload(this.payloadToJson(job.getPayload())).type(job.getType()).build();
        entity.setCreatedAt(job.getCreatedAt());
        entity.setUpdatedAt(job.getUpdatedAt());
        return entity;
    }

    public <T> T payloadToObject(String payload, Class<T> payloadType) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(payload, payloadType);
        }
        catch (JsonProcessingException e) {
            log.error("Error with mapping to json of payload {} for payload class {}", (Object)payload, (Object)payloadType.getName());
            throw new MappingException("There was an error with a job");
        }
    }

    public String payloadToJson(Object payload) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            log.error("Error with mapping to string of payload");
            throw new MappingException("There was an error with a job");
        }
    }

    public Class<?> jobTypeToClass(JobType type) {
        switch (1.$SwitchMap$io$dataintell$visionapi$scanner$JobType[type.ordinal()]) {
            case 1: {
                return ScanVolumePayload.class;
            }
            case 2: {
                return ScanBucketPayload.class;
            }
            case 3: {
                return ScanArchiwarePayload.class;
            }
        }
        return null;
    }
}

