/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.scanner;

import io.dataintell.visionapi.domain.Job;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.scanner.JobService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Hidden
public class JobController {
    private final JobService service;

    public JobController(JobService service) {
        this.service = service;
    }

    @GetMapping(value={"v1/jobs/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get a scanner by id", hidden=true)
    public Job<?> get(@PathVariable(value="id") int id) {
        return this.service.findById((long)id);
    }

    @GetMapping(value={"v1/jobs"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all jobs", hidden=true)
    public PaginatedResult<Job<?>> getAll(@RequestParam(defaultValue="0") Integer page, @RequestParam(defaultValue="10") Integer size, @RequestParam(defaultValue="id") String sort, @RequestParam(defaultValue="asc") String direction) {
        return this.service.findAll(page.intValue(), size.intValue(), sort, direction);
    }
}

