/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.scanner;

import io.dataintell.visionapi.domain.Job;
import io.dataintell.visionapi.scanner.JobStatus;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JobBundle {
    private final Map<Long, Job<?>> jobs = new LinkedHashMap();

    public JobBundle(Job<?> job) {
        this.jobs.put(job.getId(), job);
    }

    public JobBundle(List<Job<?>> list) {
        list.forEach(job -> this.jobs.put(job.getId(), job));
    }

    public boolean isFinished() {
        return this.jobs.values().stream().noneMatch(job -> JobStatus.SUCCESS != job.getStatus() && JobStatus.FAILURE != job.getStatus());
    }

    public void save(Job<?> job) {
        this.jobs.replace(job.getId(), job);
    }
}

