/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.scanner;

import io.dataintell.visionapi.config.ThreadPoolConfig;
import io.dataintell.visionapi.domain.DateHistogram;
import io.dataintell.visionapi.domain.DateIntervalType;
import io.dataintell.visionapi.domain.IdentificationHashPaginatedResponse;
import io.dataintell.visionapi.file.FileService;
import io.dataintell.visionapi.scanner.DuplicateFilesManager;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DuplicateFilesManager {
    private static final Logger log = LoggerFactory.getLogger(DuplicateFilesManager.class);
    @Value(value="${app.file.tagDuplicateFiles}")
    private Boolean tagDuplicateFiles;
    @Value(value="${app.scrollSize}")
    private Integer scrollSize;
    private final Logger logger = LoggerFactory.getLogger(DuplicateFilesManager.class);
    private final FileService fileService;
    private final ThreadPoolConfig threadPoolConfig;

    public DuplicateFilesManager(FileService fileService, ThreadPoolConfig threadPoolConfig) {
        this.fileService = fileService;
        this.threadPoolConfig = threadPoolConfig;
    }

    public void tagDuplicatedFilesForVolumesAfterDeltaScan(List<Long> volumeIds, LocalDate indexingDate) {
        log.info("About to tag duplicate files for volumes {} after a delta scan for On-Premise storage.", volumeIds);
        long start = System.currentTimeMillis();
        try {
            HashMap modifiedDateInterval = this.getHistogramOfLastModifiedFilesBasedOnData(volumeIds, indexingDate);
            this.multiThreadTagging(modifiedDateInterval, indexingDate);
        }
        catch (IOException | InterruptedException e) {
            log.error("Error while trying to tag duplicate files for volumes {} after a delta scan for On-Premise storage.", volumeIds);
        }
        long time = System.currentTimeMillis() - start;
        log.info("Finished tagging duplicate files for volumes after a delta scan for On-Premise storage {}, took {} ms", volumeIds, (Object)time);
    }

    public void tagDuplicatedFilesForVolumesAfterFullScanForOnPremise(List<Long> volumeIds, LocalDate indexingDate) {
        log.info("About to tag duplicate files for volumes {} after a full scan for On-Premise storage.", volumeIds);
        long start = System.currentTimeMillis();
        if (this.tagDuplicateFiles.booleanValue()) {
            this.tagDuplicatedFilesOnPremise(volumeIds, indexingDate);
        }
        this.tagDuplicatedFiles(volumeIds, indexingDate, Boolean.valueOf(true));
        long time = System.currentTimeMillis() - start;
        log.info("Finished tagging duplicate files for volumes after a full scan for On-Premise storage {}, took {} ms", volumeIds, (Object)time);
    }

    private void tagDuplicatedFilesOnPremise(List<Long> volumeIds, LocalDate indexingDate) {
        try {
            HashMap histogramOfLastModifiedFilesBasedOnData = this.getHistogramOfLastModifiedFilesBasedOnData(volumeIds, indexingDate);
            for (Map.Entry modifiedDateInterval : histogramOfLastModifiedFilesBasedOnData.entrySet()) {
                List identificationHashList;
                do {
                    if ((identificationHashList = this.fileService.searchIdentificationHash(volumeIds, Boolean.valueOf(false), Boolean.valueOf(false), (LocalDate)modifiedDateInterval.getValue(), (LocalDate)modifiedDateInterval.getKey(), null, null, indexingDate)).isEmpty()) continue;
                    this.fileService.tagDuplicatedFilesByHash(identificationHashList, Boolean.valueOf(true), indexingDate);
                } while (identificationHashList.size() > 0);
            }
        }
        catch (IOException e) {
            log.error("Error while trying to tag duplicate files for volumes {} after a full scan for On-Premise storage.", volumeIds);
        }
    }

    public void tagDuplicatedFilesAfterFullScan(List<Long> volumeIds, LocalDate indexingDate) {
        log.info("About to tag duplicate files for volumes {} after full scan", volumeIds);
        long start = System.currentTimeMillis();
        this.tagDuplicatedFiles(volumeIds, indexingDate, Boolean.valueOf(false));
        long time = System.currentTimeMillis() - start;
        log.info("Finished tagging duplicate files for volumes {} after full scan, took {} ms", volumeIds, (Object)time);
    }

    private void tagDuplicatedFiles(List<Long> volumeIds, LocalDate indexingDate, Boolean onlyDirectory) {
        try {
            List identificationHashList;
            do {
                identificationHashList = this.fileService.getDuplicateIdentificationHashByVolumeIds(volumeIds, indexingDate, onlyDirectory);
                this.fileService.tagDuplicatedFilesByHash(identificationHashList, Boolean.valueOf(true), indexingDate);
            } while (identificationHashList.size() > 0);
        }
        catch (IOException e) {
            log.error("Error while trying to tag duplicate files for volumes {} after full scan", volumeIds);
        }
    }

    private HashMap<LocalDate, LocalDate> getHistogramOfLastModifiedFilesBasedOnData(List<Long> volumeIds, LocalDate indexingDate) throws IOException {
        LocalDate beginningOfTime = LocalDate.of(1969, 1, 1);
        List lastModifiedHistograms = this.getLastModifiedHistograms(volumeIds, beginningOfTime, indexingDate, DateIntervalType.YEAR, indexingDate);
        this.logger.debug("Splitting into smaller time intervals");
        HashMap dateIntervals = this.populateQueue(volumeIds, indexingDate, lastModifiedHistograms, DateIntervalType.YEAR);
        this.logger.debug("Finished splitting into smaller time intervals");
        HashMap<LocalDate, LocalDate> modifiedDateInterval = new HashMap<LocalDate, LocalDate>();
        modifiedDateInterval.put(null, LocalDate.of(1970, 1, 1));
        modifiedDateInterval.put(indexingDate, null);
        modifiedDateInterval.putAll(dateIntervals);
        return modifiedDateInterval;
    }

    private HashMap<LocalDate, LocalDate> populateQueue(List<Long> volumeIds, LocalDate indexingDate, List<DateHistogram> lastModifiedHistograms, DateIntervalType dateIntervalType) {
        HashMap<LocalDate, LocalDate> modifiedDateInterval = new HashMap<LocalDate, LocalDate>();
        this.logger.debug(String.format("START - Splitting into %s with %s elements", dateIntervalType, lastModifiedHistograms.size()));
        lastModifiedHistograms.forEach(lastModifiedHistogram -> {
            LocalDate beforeDate;
            LocalDate afterDate = lastModifiedHistogram.getDate();
            DateIntervalType nextDateIntervalType = null;
            switch (1.$SwitchMap$io$dataintell$visionapi$domain$DateIntervalType[dateIntervalType.ordinal()]) {
                case 1: {
                    beforeDate = afterDate.plusWeeks(1L);
                    break;
                }
                case 2: {
                    beforeDate = afterDate.plusMonths(1L);
                    nextDateIntervalType = DateIntervalType.WEEK;
                    break;
                }
                default: {
                    beforeDate = afterDate.plusYears(1L);
                    nextDateIntervalType = DateIntervalType.MONTH;
                }
            }
            if (lastModifiedHistogram.getCount() > 15L * (long)this.scrollSize.intValue() && dateIntervalType != DateIntervalType.WEEK) {
                try {
                    List histogramList = this.getLastModifiedHistograms(volumeIds, afterDate, beforeDate, nextDateIntervalType, indexingDate);
                    modifiedDateInterval.putAll(this.populateQueue(volumeIds, indexingDate, histogramList, nextDateIntervalType));
                }
                catch (IOException e) {
                    this.logger.error("There was an error while populating the list of dates for the duplicate file tagging", (Throwable)e);
                }
            } else {
                modifiedDateInterval.put(afterDate, beforeDate);
            }
        });
        this.logger.debug(String.format("Finished - Splitting into %s with %s elements", dateIntervalType, lastModifiedHistograms.size()));
        return modifiedDateInterval;
    }

    private List<DateHistogram> getLastModifiedHistograms(List<Long> volumeIds, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, DateIntervalType dateIntervalType, LocalDate indexingDate) throws IOException {
        return this.fileService.getDateHistogramBasedOnSearch("", Boolean.valueOf(false), volumeIds, null, null, null, null, null, lastModifiedAfter, lastModifiedBefore, null, null, null, "lastModified", null, null, null, dateIntervalType, null, null, null, null, Boolean.valueOf(false), null, null, null, null, indexingDate);
    }

    private void multiThreadTagging(HashMap<LocalDate, LocalDate> modifiedDateIntervals, LocalDate indexingDate) throws InterruptedException {
        this.logger.debug("About to get the thread pool for duplicate file tagging");
        ArrayList<Callable<Integer>> callable = new ArrayList<Callable<Integer>>();
        LongAdder cpt = new LongAdder();
        for (Map.Entry<LocalDate, LocalDate> entry : modifiedDateIntervals.entrySet()) {
            callable.add(() -> this.tagByLastModifiedMonth((LocalDate)modifiedDateInterval.getKey(), (LocalDate)modifiedDateInterval.getValue(), indexingDate));
        }
        this.logger.debug(String.format("About to start the multi-thread tagging of duplicate files with a list of [%s] date intervals", modifiedDateIntervals.size()));
        for (Future future : this.threadPoolConfig.getExecutor().invokeAll(callable)) {
            try {
                cpt.add(((Integer)future.get()).intValue());
                future.isDone();
            }
            catch (Exception e) {
                this.logger.error("There was an error while tagging some duplicate files", (Throwable)e);
            }
        }
        this.logger.info(String.format("[%s] identification hashes were tagged", cpt.intValue()));
    }

    private Integer tagByLastModifiedMonth(LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate indexingDate) throws IOException {
        this.logger.debug(String.format("About to tag file that were last modified after %s and before %s", lastModifiedAfter, lastModifiedBefore));
        IdentificationHashPaginatedResponse identificationHashPaginatedResponse = this.fileService.getAllIdentificationHash(null, this.tagDuplicateFiles, lastModifiedBefore, lastModifiedAfter, indexingDate);
        int taggedHash = 0;
        while (identificationHashPaginatedResponse != null) {
            ArrayList dupeHashes = new ArrayList();
            ArrayList nonDupeHashes = new ArrayList();
            identificationHashPaginatedResponse.getIdentificationHashResponse().forEach(hash -> {
                String identificationHash = hash.getIdentificationHash();
                if (hash.getCount() > 1L && hash.getFalseCount() > 0L) {
                    dupeHashes.add(identificationHash);
                } else if (hash.getCount() < 2L && hash.getTrueCount() > 0L) {
                    nonDupeHashes.add(identificationHash);
                }
            });
            int cpt = nonDupeHashes.size() + dupeHashes.size();
            taggedHash += cpt;
            this.updateFiles(indexingDate, dupeHashes, Boolean.valueOf(true));
            this.updateFiles(indexingDate, nonDupeHashes, Boolean.valueOf(false));
            identificationHashPaginatedResponse = this.fileService.getAllIdentificationHash(identificationHashPaginatedResponse.getAfterKey(), this.tagDuplicateFiles, lastModifiedBefore, lastModifiedAfter, indexingDate);
        }
        this.logger.debug(String.format("[%s] hash were tagged for the file that were last modified after %s and before %s", taggedHash, lastModifiedAfter, lastModifiedBefore));
        return taggedHash;
    }

    private void updateFiles(LocalDate indexingDate, List<String> hashList, Boolean isDupe) throws IOException {
        if (hashList.isEmpty()) {
            return;
        }
        int numberOfThreads = 10;
        int division = hashList.size() / numberOfThreads;
        if (hashList.size() < 100) {
            this.fileService.tagDuplicatedFilesByHash(hashList, isDupe, indexingDate);
        } else {
            ArrayList<List<String>> sublist = new ArrayList<List<String>>();
            for (int i = 0; i < numberOfThreads; ++i) {
                int fromIndex = i * division;
                int toIndex = i == numberOfThreads - 1 ? hashList.size() : fromIndex + division;
                sublist.add(hashList.subList(fromIndex, toIndex));
            }
            sublist.parallelStream().forEach(l -> {
                try {
                    this.fileService.tagDuplicatedFilesByHash(l, isDupe, indexingDate);
                }
                catch (IOException e) {
                    this.logger.error("there was an error duplicates files", (Throwable)e);
                }
            });
        }
    }
}

