/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.s3Scanner;

import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.file.IngestFileProcessor;
import io.dataintell.visionapi.s3Scanner.FileBuilderFromS3;
import io.dataintell.visionapi.utils.HashUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ScanBucketHandler {
    private File previousFile = new File();
    private final HashMap<String, File> directories = new HashMap();
    private final FileBuilderFromS3 fileBuilderFromS3;
    private final IngestFileProcessor ingestFileProcessor;

    public ScanBucketHandler(File rootDirectory, IngestFileProcessor ingestFileProcessor) {
        this.directories.put(rootDirectory.getPath(), rootDirectory);
        this.fileBuilderFromS3 = new FileBuilderFromS3();
        this.ingestFileProcessor = ingestFileProcessor;
    }

    public void handleDirectory(File directory) {
        this.directories.put(directory.getPath(), directory);
        this.previousFile = directory;
    }

    public void handleFile(File file) {
        this.ingestFileProcessor.processFile(file);
        if (this.isUpdateDirectoryNeeded(file, this.directories)) {
            this.directories.put(file.getPath(), this.getUpdatedDirectory(file, (File)this.directories.get(file.getPath())));
        }
        if (this.isCreateDirectoryNeeded(this.previousFile, file)) {
            this.directories.putAll(this.getCreatedDirectories(file, Path.of(file.getPath(), new String[0])));
        }
        if (this.isCloseDirectoryNeeded(this.previousFile, file)) {
            List directoriesToSaveAndClose = this.getClosedDirectoriesPath(this.previousFile.getPath(), file.getPath());
            directoriesToSaveAndClose.forEach(dir -> {
                this.ingestFileProcessor.processFile((File)this.directories.get(dir));
                Path path = Path.of(dir, new String[0]);
                if (path.getParent() != null && this.directories.containsKey(path.getParent().toString())) {
                    this.directories.put(path.getParent().toString(), this.getUpdatedParentDirectory(path));
                }
                this.directories.remove(dir);
            });
        }
        this.previousFile = file;
    }

    public void handleRemainingDirectories() {
        List<String> lastDirectories = this.directories.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        lastDirectories.forEach(dir -> {
            this.ingestFileProcessor.processFile((File)this.directories.get(dir));
            Path path = Path.of(dir, new String[0]);
            if (path.getParent() != null && this.directories.containsKey(path.getParent().toString())) {
                this.directories.put(path.getParent().toString(), this.getUpdatedParentDirectory(path));
            }
        });
    }

    private boolean isUpdateDirectoryNeeded(File file, HashMap<String, File> directories) {
        return directories.containsKey(file.getPath());
    }

    private boolean isCreateDirectoryNeeded(File previousFile, File currentFile) {
        return previousFile.getPath() == null || !previousFile.getPath().equals(currentFile.getPath());
    }

    private boolean isCloseDirectoryNeeded(File previousFile, File currentFile) {
        return previousFile.getPath() != null && !previousFile.getPath().equals(currentFile.getPath());
    }

    private HashMap<String, File> getCreatedDirectories(File file, Path path) {
        HashMap<String, File> directoriesList = new HashMap<String, File>();
        if (path.getParent() == null || this.directories.containsKey(path.toString())) {
            return directoriesList;
        }
        File directory = this.fileBuilderFromS3.createDirectoryFromFile(file, path);
        directoriesList.put(directory.getPath(), directory);
        directoriesList.putAll(this.getCreatedDirectories(file, path.getParent()));
        return directoriesList;
    }

    private File getUpdatedDirectory(File file, File directoryToUpdate) {
        directoryToUpdate.setSize(Long.valueOf(directoryToUpdate.getSize() + file.getSize()));
        directoryToUpdate.setNumberOfFiles(Long.valueOf(directoryToUpdate.getNumberOfFiles() + 1L));
        directoryToUpdate.setIdentificationHash(HashUtils.createMD5Hash((String)(directoryToUpdate.getIdentificationHash() + file.getIdentificationHash())));
        if (directoryToUpdate.getLastModified() == null || file.getLastModified().after(directoryToUpdate.getLastModified())) {
            directoryToUpdate.setLastModified(file.getLastModified());
        }
        return directoryToUpdate;
    }

    private List<String> getClosedDirectoriesPath(String previousPath, String currentPath) {
        ArrayList<String> closedDirectories = new ArrayList<String>();
        Path previousPathFormatted = Path.of(previousPath.substring(1), new String[0]);
        Path currentPathFormatted = Path.of(currentPath.substring(1), new String[0]);
        for (int i = previousPathFormatted.getNameCount(); i >= 1; --i) {
            if (currentPathFormatted.startsWith(previousPathFormatted.subpath(0, i)) || previousPathFormatted.subpath(0, i).toString().isEmpty()) continue;
            closedDirectories.add("/" + previousPathFormatted.subpath(0, i));
        }
        return closedDirectories;
    }

    private File getUpdatedParentDirectory(Path path) {
        File directory = (File)this.directories.get(path.toString());
        File parentDirectory = (File)this.directories.get(path.getParent().toString());
        parentDirectory.setSize(Long.valueOf(parentDirectory.getSize() + directory.getSize()));
        parentDirectory.setNumberOfFiles(Long.valueOf(parentDirectory.getNumberOfFiles() + directory.getNumberOfFiles()));
        parentDirectory.setNumberOfFolders(Long.valueOf(parentDirectory.getNumberOfFolders() + directory.getNumberOfFolders() + 1L));
        if (!directory.getIdentificationHash().equals("")) {
            parentDirectory.setIdentificationHash(HashUtils.createMD5Hash((String)(parentDirectory.getIdentificationHash() + directory.getIdentificationHash())));
        }
        if (parentDirectory.getLastModified() == null || directory.getLastModified().after(parentDirectory.getLastModified())) {
            parentDirectory.setLastModified(directory.getLastModified());
        }
        return parentDirectory;
    }
}

