/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.s3Scanner;

import io.dataintell.visionapi.domain.Bucket;
import io.dataintell.visionapi.domain.BucketType;
import io.dataintell.visionapi.domain.CloudCredentials;
import io.dataintell.visionapi.problem.S3BucketException;
import io.dataintell.visionapi.s3Scanner.S3ClientBuilder;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;

public class S3ClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(S3ClientBuilder.class);
    private final String namespace;
    private final BucketType bucketType;
    private final CloudCredentials credentials;
    private final String region;

    public S3ClientBuilder(Bucket bucket, CloudCredentials credentials) {
        this.bucketType = bucket.getType();
        this.credentials = credentials;
        this.region = bucket.getRegion();
        this.namespace = bucket.getNamespace();
    }

    public S3ClientBuilder(CloudCredentials cloudCredentials, String region, String namespace) {
        this.bucketType = cloudCredentials.getType();
        this.credentials = cloudCredentials;
        this.region = region;
        this.namespace = namespace;
    }

    public S3Client build() {
        switch (1.$SwitchMap$io$dataintell$visionapi$domain$BucketType[this.bucketType.ordinal()]) {
            case 1: {
                return this.getS3ClientForOracle();
            }
            case 2: {
                return this.getS3ClientForB2();
            }
            case 3: {
                return this.getS3ClientForWasabi();
            }
        }
        return this.getS3ClientForS3();
    }

    private S3Client getS3ClientForOracle() {
        String endpoint = String.format("https://%s.compat.objectstorage.%s.oraclecloud.com", this.namespace, this.region);
        AwsSessionCredentials awsCreds = AwsSessionCredentials.create((String)this.credentials.getAccessKey(), (String)this.credentials.getPrivateKey(), (String)"");
        return (S3Client)((software.amazon.awssdk.services.s3.S3ClientBuilder)((software.amazon.awssdk.services.s3.S3ClientBuilder)((software.amazon.awssdk.services.s3.S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).endpointOverride(URI.create(endpoint))).region(Region.of((String)this.region))).build();
    }

    private S3Client getS3ClientForB2() {
        String endpoint = String.format("https://s3.%s.backblazeb2.com", this.region);
        AwsSessionCredentials awsCreds = AwsSessionCredentials.create((String)this.credentials.getAccessKey(), (String)this.credentials.getPrivateKey(), (String)"");
        return (S3Client)((software.amazon.awssdk.services.s3.S3ClientBuilder)((software.amazon.awssdk.services.s3.S3ClientBuilder)((software.amazon.awssdk.services.s3.S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).endpointOverride(URI.create(endpoint))).region(Region.of((String)this.region))).build();
    }

    private S3Client getS3ClientForWasabi() {
        String endpoint = String.format("https://s3.%s.wasabisys.com", this.region);
        AwsSessionCredentials awsCreds = AwsSessionCredentials.create((String)this.credentials.getAccessKey(), (String)this.credentials.getPrivateKey(), (String)"");
        return (S3Client)((software.amazon.awssdk.services.s3.S3ClientBuilder)((software.amazon.awssdk.services.s3.S3ClientBuilder)((software.amazon.awssdk.services.s3.S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).endpointOverride(URI.create(endpoint))).region(Region.of((String)this.region))).build();
    }

    private S3Client getS3ClientForS3() {
        AwsBasicCredentials awsBasicCredentials = AwsBasicCredentials.create((String)this.credentials.getAccessKey(), (String)this.credentials.getPrivateKey());
        try {
            return (S3Client)((software.amazon.awssdk.services.s3.S3ClientBuilder)((software.amazon.awssdk.services.s3.S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsBasicCredentials))).region(Region.of((String)this.region))).build();
        }
        catch (SdkClientException e) {
            String message = String.format("Error with region [%s]", this.region);
            log.error(message);
            throw new S3BucketException(message);
        }
    }
}

