/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.s3Scanner;

import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.utils.HashUtils;
import io.dataintell.visionapi.utils.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;
import software.amazon.awssdk.services.s3.model.ObjectStorageClass;
import software.amazon.awssdk.services.s3.model.S3Object;

@Component
public class FileBuilderFromS3 {
    public File createFileFromS3Object(S3Object obj, String volumeName, Long volumeId) {
        Path path = Paths.get("/" + obj.key(), new String[0]);
        File file = this.createBasicFileFromS3(path.getParent(), Date.from(obj.lastModified()), volumeId, volumeName);
        file.setName(path.getFileName().toString());
        file.setSize(obj.size());
        file.setExtension(FilenameUtils.getExtension((String)path.getFileName().toString()));
        file.setNumericNameList(StringUtils.removeAllNonNumericAndReturnListOfNumbers((String)file.getName()));
        file.setFileId(HashUtils.getDocumentId((String)("f-" + file.getName()), (String)path.getParent().toString(), (Long)volumeId, (Boolean)false));
        file.setIdentificationHash(obj.eTag());
        file.setIsDirectory(Boolean.valueOf(false));
        HashMap<String, ObjectStorageClass> metadata = new HashMap<String, ObjectStorageClass>();
        metadata.put("storageClass", obj.storageClass());
        file.setMetadata(metadata);
        return file;
    }

    public File createDirectoryFromS3Object(S3Object s3Object, String volumeName, Long volumeId) {
        Path path = Paths.get("/" + s3Object.key().substring(0, s3Object.key().length() - 1), new String[0]);
        File directory = this.createBasicDirectoryFromS3(path, Date.from(s3Object.lastModified()), volumeId, volumeName);
        directory.setSize(s3Object.size());
        return directory;
    }

    public File createDirectoryFromFile(File file, Path path) {
        File directory = this.createBasicDirectoryFromS3(path, file.getLastModified(), file.getVolumeId(), file.getVolumeName());
        if (file.getPath().equals(path.toString())) {
            directory.setSize(file.getSize());
            directory.setNumberOfFiles(Long.valueOf(1L));
            directory.setIdentificationHash(HashUtils.createMD5Hash((String)file.getIdentificationHash()));
        }
        return directory;
    }

    public File createBasicDirectoryFromS3(Path path, Date lastModified, Long volumeId, String volumeName) {
        File directory = this.createBasicFileFromS3(path, lastModified, volumeId, volumeName);
        directory.setNumberOfFiles(Long.valueOf(0L));
        directory.setNumberOfFolders(Long.valueOf(0L));
        directory.setIdentificationHash("");
        return directory;
    }

    private File createBasicFileFromS3(Path path, Date lastModified, Long volumeId, String volumeName) {
        File directory = new File();
        String directoryName = "";
        if (!path.toString().equals("/")) {
            directoryName = path.getFileName().toString();
        }
        directory.setPath(path.toString());
        directory.setName(directoryName);
        directory.setIsDirectory(Boolean.valueOf(true));
        directory.setIsDeleted(Boolean.valueOf(false));
        directory.setIsDupe(Boolean.valueOf(false));
        directory.setIndexingDate(new Date());
        directory.setLastModified(lastModified);
        directory.setVolumeId(volumeId);
        directory.setVolumeName(volumeName);
        directory.setFileId(HashUtils.getDocumentId((String)directoryName, (String)directory.getPath(), (Long)directory.getVolumeId(), (Boolean)true));
        directory.setSize(Long.valueOf(0L));
        return directory;
    }
}

