/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.repository.elasticsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.permission.Action;
import io.dataintell.visionapi.permission.ResourceFilterBuilder;
import io.dataintell.visionapi.permission.ResourceType;
import io.dataintell.visionapi.problem.BadRequestException;
import io.dataintell.visionapi.security.AuthenticationHelper;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VolumeRepository {
    private static final Logger log = LoggerFactory.getLogger(VolumeRepository.class);
    private final RestHighLevelClient elasticsearchClient;
    private final ResourceFilterBuilder resourceFilterBuilder;

    public VolumeRepository(RestHighLevelClient elasticsearchClient, ResourceFilterBuilder resourceFilterBuilder) {
        this.elasticsearchClient = elasticsearchClient;
        this.resourceFilterBuilder = resourceFilterBuilder;
    }

    public Optional<SearchResponse> findById(Long id) {
        List roles = AuthenticationHelper.getAuthoritiesList();
        boolean isRequestDenied = roles.stream().flatMap(role -> role.getPrivileges().stream()).anyMatch(p -> ResourceType.VOLUME == p.getResourceType() && Action.DENY == p.getAction() && id.equals(p.getResourceId()));
        if (isRequestDenied) {
            log.info("Access denied for volume with id [{}]", (Object)id);
            throw new BadRequestException(String.format("Access denied for volume with id [%s]", id));
        }
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"id", (Object)id)).sort("indexingDate", SortOrder.DESC).size(1);
        searchRequest.source(searchSourceBuilder);
        searchRequest.indices(new String[]{"volume"});
        try {
            SearchResponse searchResponse = this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.getHits().getHits().length == 0) {
                return Optional.empty();
            }
            return Optional.of(searchResponse);
        }
        catch (IOException e) {
            log.error("Unable to reach Es cluster", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<SearchResponse> findVolumeHistoryById(int page, int size, String sortField, String direction, long id, LocalDate fromDate, LocalDate toDate) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.VOLUME).filter((QueryBuilder)new TermQueryBuilder("id", id)).filter((QueryBuilder)new RangeQueryBuilder("indexingDate").gte((Object)fromDate).lte((Object)toDate));
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(SortOrder.fromString((String)direction));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).sort((SortBuilder)sortBuilder).size(size).from(page == 0 ? 0 : page - 1);
        SearchRequest searchRequest = new SearchRequest(new String[]{IndexType.VOLUME.label}).source(searchSourceBuilder);
        try {
            return Optional.of(this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT));
        }
        catch (IOException e) {
            log.error("Unable to reach Es cluster", (Throwable)e);
            return Optional.empty();
        }
    }

    public SearchResponse getAll(Integer from, Integer size, String fieldSort, SortOrder sortDirection, HashMap<Long, Long> volumeIdsAndIndexingDate, LocalDate indexingDate) throws IOException {
        return this.returnAll(from, size, fieldSort, sortDirection, volumeIdsAndIndexingDate, indexingDate);
    }

    public SearchResponse getAllMostRecent(Integer from, Integer size, String fieldSort, String sortDirection, HashMap<Long, Long> volumeIdsAndIndexingDate, LocalDate indexingDate, List<Long> volumeSettingIds) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.getBoolQueryForMostRecentDate(indexingDate, volumeSettingIds);
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)fieldSort);
        sortBuilder.order(SortOrder.fromString((String)sortDirection));
        SearchRequest searchRequest = new SearchRequest(new String[]{"volume"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (volumeIdsAndIndexingDate != null) {
            boolQueryBuilder.filter((QueryBuilder)this.getBasicBoolQueryBuilder(volumeIdsAndIndexingDate));
        }
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).from(from.intValue()).size(size.intValue()).sort((SortBuilder)sortBuilder);
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getVolumesPerDay(Integer from, Integer size, String fieldSort, SortOrder sortDirection, LocalDate indexingDate) throws IOException {
        return this.returnAll(from, size, fieldSort, sortDirection, null, indexingDate);
    }

    public SearchResponse findAllDistinctIndexingDateNearDateForAllVolume(LocalDate indexingDate, Integer size) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.VOLUME);
        boolQueryBuilder.must((QueryBuilder)new RangeQueryBuilder("indexingDate").gte((Object)indexingDate.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        SearchRequest searchRequest = new SearchRequest(new String[]{"volume"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).from(0).size(0).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"volumeId").field("id")).size(size.intValue()).subAggregation((AggregationBuilder)AggregationBuilders.min((String)"closestDate").field("indexingDate")));
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    private SearchResponse returnAll(Integer from, Integer size, String fieldSort, SortOrder sortDirection, HashMap<Long, Long> volumeIdsAndIndexingDate, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.getBoolQueryForDate(indexingDate);
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)fieldSort);
        sortBuilder.order(sortDirection);
        SearchRequest searchRequest = new SearchRequest(new String[]{"volume"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).from(from.intValue()).size(size.intValue()).sort((SortBuilder)sortBuilder);
        searchRequest.source(searchSourceBuilder);
        if (volumeIdsAndIndexingDate != null) {
            searchSourceBuilder.postFilter((QueryBuilder)this.getBasicBoolQueryBuilder(volumeIdsAndIndexingDate));
        }
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void indexVolume(Volume volume) {
        try {
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").create();
            IndexRequest indexRequest = new IndexRequest("volume").id(volume.getDocumentId()).source(gson.toJson((Object)volume), XContentType.JSON);
            this.elasticsearchClient.index(indexRequest, RequestOptions.DEFAULT);
            this.refreshIndex();
        }
        catch (IOException e) {
            log.error("There was an error saving volume with id [{}]", (Object)volume.getId());
        }
    }

    public SearchResponse getLatestVolumes(LocalDate indexingDate) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{"volume"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)this.getBoolQueryForDate(indexingDate)).from(0).size(0).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"volumeId").field("id")).size(500).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"mostRecent").field("indexingDate")));
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getMostRecentVolumes(LocalDate indexingDate, List<Long> volumeSettingIds) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{"volume"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)this.getBoolQueryForMostRecentDate(indexingDate, volumeSettingIds)).from(0).size(0).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"volumeId").field("id")).size(500).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"mostRecent").field("indexingDate")));
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void deleteVolumeFromLastIndexingDate(Long id, LocalDate indexingDate) throws IOException {
        DeleteByQueryRequest request = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{"volume"}).setRefresh(true);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("id", (Object)id));
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").gte((Object)indexingDate.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        request.setQuery((QueryBuilder)boolQueryBuilder);
        this.elasticsearchClient.deleteByQuery(request, RequestOptions.DEFAULT);
    }

    private BoolQueryBuilder getBoolQueryForDate(LocalDate indexingDate) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.VOLUME);
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").gte((Object)indexingDate.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lt((Object)indexingDate.plusDays(1L).atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        return boolQueryBuilder;
    }

    private BoolQueryBuilder getBoolQueryForMostRecentDate(LocalDate indexingDate, List<Long> volumeSettingIds) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.VOLUME);
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lt((Object)indexingDate.plusDays(1L).atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("id", volumeSettingIds));
        return boolQueryBuilder;
    }

    private BoolQueryBuilder getBasicBoolQueryBuilder(HashMap<Long, Long> volumeIdsAndIndexingDate) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.VOLUME);
        BoolQueryBuilder versionsBoolQueryBuilder = new BoolQueryBuilder();
        for (Map.Entry<Long, Long> longLongEntry : volumeIdsAndIndexingDate.entrySet()) {
            BoolQueryBuilder versionBoolQueryBuilder = new BoolQueryBuilder();
            versionBoolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("id", (Object)longLongEntry.getKey()));
            versionBoolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("indexingDate", (Object)longLongEntry.getValue()));
            versionsBoolQueryBuilder.should((QueryBuilder)versionBoolQueryBuilder);
        }
        versionsBoolQueryBuilder.minimumShouldMatch(1);
        boolQueryBuilder.filter((QueryBuilder)versionsBoolQueryBuilder);
        return boolQueryBuilder;
    }

    private void refreshIndex() throws IOException {
        RefreshRequest request = new RefreshRequest(new String[]{"volume"});
        this.elasticsearchClient.indices().refresh(request, RequestOptions.DEFAULT);
    }
}

