/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.repository.elasticsearch;

import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.repository.elasticsearch.IndexRepository;
import io.dataintell.visionapi.utils.ESFileQueryUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.client.indices.ResizeRequest;
import org.elasticsearch.client.indices.ResizeResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IndexRepository {
    @Value(value="${file.settings.shards}")
    private String fileNumberOfShards;
    @Value(value="${file.settings.replicas}")
    private String fileNumberOfReplicas;
    @Value(value="${volume.settings.shards}")
    private String volumeNumberOfShards;
    @Value(value="${volume.settings.shards}")
    private String volumeNumberOfReplicas;
    @Value(value="${project.settings.shards}")
    private String projectNumberOfShards;
    @Value(value="${project.settings.replicas}")
    private String projectNumberOfReplicas;
    @Value(value="${app.support.characters}")
    private String supportedCharacters;
    @Autowired
    ESFileQueryUtils esFileQueryUtils;
    @Autowired
    RestHighLevelClient elasticsearchClient;
    private static final Logger logger = LoggerFactory.getLogger(IndexRepository.class);

    public List<String> getIndices() throws IOException {
        GetMappingsResponse response = this.elasticsearchClient.indices().getMapping(new GetMappingsRequest().indices(new String[]{"*"}), RequestOptions.DEFAULT);
        return new ArrayList<String>(response.mappings().keySet());
    }

    public void deleteFileIndex(LocalDate indexingDate) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String indexName = "file-" + indexingDate.format(formatter);
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        this.elasticsearchClient.indices().delete(request, RequestOptions.DEFAULT);
    }

    public void deleteContentByDate(LocalDate indexingDate, IndexType indexType) throws IOException {
        if (!indexType.equals((Object)IndexType.PROJECT) && !indexType.equals((Object)IndexType.VOLUME)) {
            return;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").gte((Object)indexingDate.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lt((Object)indexingDate.plusDays(1L).atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        DeleteByQueryRequest delete = new DeleteByQueryRequest(new String[]{indexType.label}).setQuery((QueryBuilder)boolQueryBuilder);
        this.elasticsearchClient.deleteByQuery(delete, RequestOptions.DEFAULT);
    }

    public void reindex(String sourceIndex, String destIndex) throws IOException {
        ReindexRequest request = new ReindexRequest();
        request.setSourceIndices(new String[]{sourceIndex});
        request.setDestIndex(destIndex);
        request.setSlices(4);
        BulkByScrollResponse bulkResponse = this.elasticsearchClient.reindex(request, RequestOptions.DEFAULT);
    }

    public void cloneFileIndex(String sourceIndex, String destIndex) throws IOException {
        this.updateBlockWriteSettings(true, sourceIndex);
        ResizeRequest resizeRequest = new ResizeRequest(destIndex, sourceIndex);
        resizeRequest.setWaitForActiveShards(ActiveShardCount.ALL);
        resizeRequest.setSettings(Settings.builder().put("index.number_of_replicas", this.fileNumberOfReplicas).build());
        ResizeResponse resizeResponse = this.elasticsearchClient.indices().clone(resizeRequest, RequestOptions.DEFAULT);
        this.updateBlockWriteSettings(false, destIndex);
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void updateBlockWriteSettings(boolean blockWrite, String index) throws IOException {
        String settingKey = "index.blocks.write";
        UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{index});
        Settings.Builder settingsBuilder = Settings.builder().put(settingKey, blockWrite);
        request.settings(settingsBuilder);
        this.elasticsearchClient.indices().putSettings(request, RequestOptions.DEFAULT);
    }

    public void createIndex(IndexType indexType, LocalDate indexingDate) throws IOException, NotFoundException {
        String index;
        String numberOfReplicas;
        String numberOfShards;
        switch (1.$SwitchMap$io$dataintell$visionapi$domain$IndexType[indexType.ordinal()]) {
            case 1: {
                numberOfShards = this.fileNumberOfShards;
                numberOfReplicas = this.fileNumberOfReplicas;
                index = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
                break;
            }
            case 2: {
                numberOfShards = this.volumeNumberOfShards;
                numberOfReplicas = this.volumeNumberOfReplicas;
                index = "volume";
                break;
            }
            case 3: {
                numberOfShards = this.projectNumberOfShards;
                numberOfReplicas = this.projectNumberOfReplicas;
                index = "project";
                break;
            }
            default: {
                throw new NotFoundException(String.format("Index type %s doesn't exist", indexType));
            }
        }
        String mapping = this.getMapping(indexType);
        String settings = this.getSettings();
        settings = settings.replace("numberOfShards", numberOfShards);
        settings = settings.replace("numberOfReplicas", numberOfReplicas);
        GetIndexRequest indexExist = new GetIndexRequest(new String[]{index});
        boolean exists = this.elasticsearchClient.indices().exists(indexExist, RequestOptions.DEFAULT);
        if (!exists) {
            CreateIndexRequest request = new CreateIndexRequest(index);
            request.settings(settings, XContentType.JSON);
            CreateIndexResponse createIndexResponse = this.elasticsearchClient.indices().create(request, RequestOptions.DEFAULT);
        }
        PutMappingRequest mappingRequest = new PutMappingRequest(new String[]{index});
        mappingRequest.source(mapping, XContentType.JSON);
        AcknowledgedResponse putMappingResponse = this.elasticsearchClient.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
    }

    private String getSettings() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return IOUtils.toString((InputStream)classLoader.getResourceAsStream("mappings/settings.json"), (Charset)Charset.defaultCharset());
    }

    private String getMapping(IndexType indexType) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String file = StringUtils.isBlank((CharSequence)this.supportedCharacters) ? String.format("mappings/%s.json", indexType.label) : String.format("mappings/%s-%s.json", indexType.label, this.supportedCharacters);
        return IOUtils.toString((InputStream)classLoader.getResourceAsStream(file), (Charset)Charset.defaultCharset());
    }

    public void refreshFileIndex(LocalDate indexingDate) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String indexName = "file-" + indexingDate.format(formatter);
        RefreshRequest request = new RefreshRequest(new String[]{indexName});
        RefreshResponse refreshResponse = this.elasticsearchClient.indices().refresh(request, RequestOptions.DEFAULT);
    }

    public List<TaskInfo> getTasksByName(String name) throws IOException {
        ListTasksRequest listTasksRequest = new ListTasksRequest();
        ((ListTasksRequest)listTasksRequest.setActions(new String[]{name})).setDetailed(true);
        ListTasksResponse response = this.elasticsearchClient.tasks().list(listTasksRequest, RequestOptions.DEFAULT);
        return response.getTasks();
    }
}

